<?php
/*
|--------------------------------------------------------------------------
| Sidebar Menu Structure
|--------------------------------------------------------------------------
| Level 1: Super Admin
| Level 2: Admin
| Level 3: Guru
| Level 4: Peserta
|
*/
?>
<!-- Left side column. contains the logo and sidebar -->
<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <div class="user-panel">
        <div class="pull-left image">
          <img src="../../images/user_default.png" class="img-circle" alt="User Image" onerror="this.src='../../public/dist/img/user2-160x160.jpg'">
        </div>
        <div class="pull-left info">
          <p><?php echo isset($_SESSION['nama']) ? $_SESSION['nama'] : 'User'; ?></p>
          <a href="#"><i class="fa fa-circle text-success"></i> <?php echo isset($_SESSION['email']) ? $_SESSION['email'] : ''; ?></a>
        </div>
      </div>

      <!-- sidebar menu: : style can be found in sidebar.less -->
      <ul class="sidebar-menu" data-widget="tree">
        <li class="header">MAIN NAVIGATION</li>

        <li>
          <a href="../admin/">
            <i class="fa fa-dashboard"></i> <span>Dashboard</span>
          </a>
        </li>

        <?php 
        $level = isset($_SESSION['level_id']) ? $_SESSION['level_id'] : 0;
        ?>

        <!-- MENU LEVEL 1 (ADMIN) -->
        <?php if($level == 1 || $level == 2): ?>
            <li class="treeview">
              <a href="#">
                <i class="fa fa-users"></i>
                <span>Users</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li><a href="../m_user/ganti_password.php"><i class="fa fa-key"></i> Change Password</a></li>
                <li><a href="../m_user/admin.php"><i class="fa fa-user"></i> Admin</a></li>
                <li><a href="../m_user/driver_dump.php"><i class="fa fa-truck"></i> Driver Dump</a></li>
                <li><a href="../m_user/operator_exca.php"><i class="fa fa-cog"></i> Operator Exca</a></li>
              </ul>
            </li>

            <li class="treeview">
              <a href="#">
                <i class="fa fa-database"></i>
                <span>Master Data</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li><a href="../m_lhl/"><i class="fa fa-sticky-note"></i> Lhl</a></li>
                <li><a href="../m_area/"><i class="fa fa-map"></i> Area</a></li>
                <li><a href="../m_pit/"><i class="fa fa-map-marker"></i> Pit</a></li>
                <li><a href="../m_rom/"><i class="fa fa-cubes"></i> Rom</a></li>
                <li><a href="../m_mining_cont/"><i class="fa fa-building"></i> Mining Contractor</a></li>
                <li><a href="../m_type_unit/"><i class="fa fa-tags"></i> Type Unit</a></li>
                <li><a href="../m_heq/"><i class="fa fa-truck"></i> Heavy Equipment</a></li>
                <li><a href="../m_kategori_material/"><i class="fa fa-folder"></i> Kategori Material</a></li>
                <li><a href="../m_material/"><i class="fa fa-cube"></i> Material</a></li>
              </ul>
            </li>

            <li class="treeview">
              <a href="#">
                <i class="fa fa-cogs"></i>
                <span>Process</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li><a href="../m_pop/"><i class="fa fa-industry"></i> Point Of Production (POP)</a></li>
              </ul>
            </li>

            <li class="treeview">
              <a href="#">
                <i class="fa fa-tint"></i>
                <span>Fuel Management</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li><a href="../m_fueling/"><i class="fa fa-fire"></i> Fueling (Pengisian Fuel)</a></li>
                <li><a href="../m_fuel_stock/"><i class="fa fa-database"></i> Fuel Stock</a></li>
                <li><a href="../m_fuel_report/"><i class="fa fa-bar-chart"></i> Fuel Consumption Report</a></li>
              </ul>
            </li>
            
            <li class="treeview">
              <a href="#">
                <i class="fa fa-file-text"></i>
                <span>Report</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li><a href="../m_pop/report_pop.php"><i class="fa fa-bar-chart"></i> POP</a></li>
              </ul>
            </li>

            <li>
              <a href="../pengaturan/">
                <i class="fa fa-gear"></i> <span>Setting</span>
              </a>
            </li>

        <?php endif; ?>

        <li><a href="../../logout.php"><i class="fa fa-sign-out text-red"></i> <span>Log Out</span></a></li>
      </ul>
    </section>
    <!-- /.sidebar -->
  </aside>