<?php
// View/m_user/guru.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Get Jenis Guru
$jenis_guru = $conn->query("SELECT * FROM m_jenis_guru")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Data Guru
        <small>Pengguna</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Pengguna</li>
        <li class="active">Guru</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Guru</button>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>No</th>
                      <th>Nama</th>
                      <th>Mata Pelajaran</th>
                      <th>Email</th>
                      <th>No HP</th>
                      <th>Status</th>
                      <th>Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    // Join with m_jenis_guru
                    $sql = "SELECT m_user.*, m_jenis_guru.nama as mapel 
                            FROM m_user 
                            LEFT JOIN m_jenis_guru ON m_user.m_jenis_guru_id = m_jenis_guru.id 
                            WHERE m_user.level_id = 3 
                            ORDER BY m_user.id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $status = ($row['status_aktif'] == 1) ? '<span class="label label-success">Aktif</span>' : '<span class="label label-danger">Tidak Aktif</span>';
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><?php echo $row['nama']; ?></td>
                      <td><?php echo $row['mapel']; ?></td>
                      <td><?php echo $row['email']; ?></td>
                      <td><?php echo $row['hp']; ?></td>
                      <td><?php echo $status; ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel">Tambah Guru</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="form-group">
            <label>Nama Lengkap</label>
            <input type="text" name="nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Mata Pelajaran</label>
            <select name="m_jenis_guru_id" class="form-control select2" style="width: 100%;" required>
                <option value="">-- Pilih --</option>
                <?php foreach($jenis_guru as $jg): ?>
                <option value="<?php echo $jg['id']; ?>"><?php echo $jg['nama']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <div class="form-group">
            <label>No HP</label>
            <input type="text" name="hp" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel">Edit Guru</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>Nama Lengkap</label>
            <input type="text" name="nama" id="edit_nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Mata Pelajaran</label>
            <select name="m_jenis_guru_id" id="edit_jenis_guru" class="form-control select2" style="width: 100%;" required>
                <option value="">-- Pilih --</option>
                <?php foreach($jenis_guru as $jg): ?>
                <option value="<?php echo $jg['id']; ?>"><?php echo $jg['nama']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" id="edit_email" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Password (Kosongkan jika tidak ubah)</label>
            <input type="password" name="password" class="form-control">
        </div>
        <div class="form-group">
            <label>No HP</label>
            <input type="text" name="hp" id="edit_hp" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    $('#example1').DataTable();
    $('.select2').select2();

    // Add
    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/GuruController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                var data = JSON.parse(res);
                if(data.status == 'success'){
                    alert(data.message);
                    location.reload();
                } else {
                    alert(data.message);
                }
            }
        });
    });

    // Get Data for Edit
    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/GuruController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_nama').val(data.nama);
                $('#edit_jenis_guru').val(data.m_jenis_guru_id);
                $('#edit_email').val(data.email);
                $('#edit_hp').val(data.hp);
                $('#editModal').modal('show');
            }
        });
    });

    // Update
    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/GuruController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                var data = JSON.parse(res);
                alert(data.message);
                location.reload();
            }
        });
    });

    // Delete
    $('.delete-btn').on('click', function(){
        if(confirm('Are you sure?')){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/GuruController.php?action=delete',
                method: 'POST',
                data: {id: id},
                success: function(res){
                    var data = JSON.parse(res);
                    alert(data.message);
                    location.reload();
                }
            });
        }
    });
});
</script>
