<?php
// Include config database
include '../../config.php';

// Pastikan session dimulai (jika di config.php belum ada session_start)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 1. Cek apakah user sudah login menggunakan email (sesuai index_manager.php)
if (empty($_SESSION['email'])) {
    echo "<script>alert('Sesi habis atau Anda belum login.'); window.location='../../index.php';</script>";
    exit();
}

// Ambil data
$email_user     = $_SESSION['email']; // Gunakan Email sebagai kunci
$password_baru  = $_POST['password_baru'];

// 2. Enkripsi Password Baru
// Menggunakan PASSWORD_DEFAULT agar sesuai dengan hash $2y$10$ di database Anda
$password_hash  = password_hash($password_baru, PASSWORD_DEFAULT);

try {
    // 3. Update password berdasarkan EMAIL, bukan ID
    $sql = "UPDATE m_user SET password = :password WHERE email = :email";
    $stmt = $conn->prepare($sql);
    
    $params = [
        ':password' => $password_hash,
        ':email'    => $email_user
    ];

    $execute = $stmt->execute($params);

    // 4. Cek apakah ada baris yang berubah
    if ($execute && $stmt->rowCount() > 0) {
        // Sukses
        echo "<script>
            alert('Password BERHASIL diubah! Silakan login ulang.');
            window.location='../../logout.php'; 
        </script>";
    } else {
        // Query jalan tapi tidak ada data yg berubah 
        // (Bisa karena email tidak ketemu, atau password sama persis)
        echo "<script>
            alert('Gagal mengubah password. Pastikan Anda login dengan benar atau password baru berbeda dengan yang lama.');
            window.history.back();
        </script>";
    }

} catch (PDOException $e) {
    echo "Error System: " . $e->getMessage();
}
?>