<?php
// View/m_user/admin.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';
?>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Data Admin
        <small>Pengguna</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Pengguna</li>
        <li class="active">Admin</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Admin</button>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>No</th>
                      <th>Nama</th>
                      <th>Email</th>
                      <th>No HP</th>
                      <th>Status</th>
                      <th>Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT * FROM m_user WHERE level_id = 1 ORDER BY id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $status = ($row['status_aktif'] == 1) ? '<span class="label label-success">Aktif</span>' : '<span class="label label-danger">Tidak Aktif</span>';
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><?php echo $row['nama']; ?></td>
                      <td><?php echo $row['email']; ?></td>
                      <td><?php echo $row['hp']; ?></td>
                      <td><?php echo $status; ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel">Tambah Admin</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="form-group">
            <label>Nama Lengkap</label>
            <input type="text" name="nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <div class="form-group">
            <label>No HP</label>
            <input type="text" name="hp" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel">Edit Admin</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>Nama Lengkap</label>
            <input type="text" name="nama" id="edit_nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" id="edit_email" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Password (Kosongkan jika tidak ubah)</label>
            <input type="password" name="password" class="form-control">
        </div>
        <div class="form-group">
            <label>No HP</label>
            <input type="text" name="hp" id="edit_hp" class="form-control">
        </div>
        <div class="form-group">
            <label>Status</label>
            <select name="status_aktif" id="edit_status" class="form-control">
                <option value="1">Aktif</option>
                <option value="0">Tidak Aktif</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    $('#example1').DataTable();

    // Add
    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/AdminController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                var data = JSON.parse(res);
                if(data.status == 'success'){
                    alert(data.message);
                    location.reload();
                } else {
                    alert(data.message);
                }
            }
        });
    });

    // Get Data for Edit
    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/AdminController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_nama').val(data.nama);
                $('#edit_email').val(data.email);
                $('#edit_hp').val(data.hp);
                $('#edit_status').val(data.status_aktif);
                $('#editModal').modal('show');
            }
        });
    });

    // Update
    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/AdminController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                var data = JSON.parse(res);
                alert(data.message);
                location.reload();
            }
        });
    });

    // Delete
    $('.delete-btn').on('click', function(){
        if(confirm('Are you sure?')){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/AdminController.php?action=delete',
                method: 'POST',
                data: {id: id},
                success: function(res){
                    var data = JSON.parse(res);
                    alert(data.message);
                    location.reload();
                }
            });
        }
    });
});
</script>
