<?php
include '../../config.php';
session_start();

if(!isset($_SESSION['email'])){
    header("location:../../index.php");
}

$_SESSION['menu'] = 'Master Data';
$_SESSION['submenu'] = 'ROM';
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>SITEM | Data ROM (Run Of Mine)</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <?php include '../header.php'; ?>
    
</head>
<body class="hold-transition skin-blue (black-light) sidebar-mini">
<div class="wrapper">

    <?php include '../navbar.php'; ?>
    <?php include '../sidebar.php'; ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Data ROM (Run Of Mine)
                <small>Master Data</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Data ROM</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header">
                            <h3 class="box-title">Daftar ROM</h3>
                            <button type="button" class="btn btn-primary pull-right" data-toggle="modal" data-target="#modal-add">
                                <i class="fa fa-plus"></i> Tambah ROM
                            </button>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Area</th>
                                    <th>Pit</th>
                                    <th>Nama ROM</th>
                                    <th>Deskripsi</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $no = 1;
                                $sql = "
                                    SELECT r.*, a.nama as nama_area, p.nama as nama_pit 
                                    FROM m_rom r 
                                    JOIN m_area a ON r.area_id = a.id 
                                    JOIN m_pit p ON r.pit_id = p.id 
                                    ORDER BY r.id DESC
                                ";
                                $stmt = $conn->prepare($sql);
                                $stmt->execute();
                                while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
                                    ?>
                                    <tr>
                                        <td><?php echo $no++; ?></td>
                                        <td><?php echo htmlspecialchars($row['nama_area']); ?></td>
                                        <td><?php echo htmlspecialchars($row['nama_pit']); ?></td>
                                        <td><?php echo htmlspecialchars($row['nama']); ?></td>
                                        <td><?php echo htmlspecialchars($row['des']); ?></td>
                                        <td>
                                            <?php if($row['status'] == 1): ?>
                                                <span class="label label-success">Aktif</span>
                                            <?php else: ?>
                                                <span class="label label-danger">Tidak Aktif</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning btn-xs btn-edit" 
                                                    data-id="<?php echo $row['id']; ?>"
                                                    data-area_id="<?php echo $row['area_id']; ?>"
                                                    data-pit_id="<?php echo $row['pit_id']; ?>"
                                                    data-nama="<?php echo htmlspecialchars($row['nama']); ?>"
                                                    data-des="<?php echo htmlspecialchars($row['des']); ?>"
                                                    data-status="<?php echo $row['status']; ?>">
                                                <i class="fa fa-pencil"></i>
                                            </button>
                                            <button class="btn btn-danger btn-xs btn-delete" data-id="<?php echo $row['id']; ?>">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <?php include '../footer.php'; ?>

    <!-- Add Modal -->
    <div class="modal fade" id="modal-add">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="form-add">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Tambah ROM</h4>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Area <span class="text-danger">*</span></label>
                            <select class="form-control select2" name="area_id" id="add_area_id" required style="width: 100%;">
                                <option value="">Pilih Area</option>
                                <?php
                                $sql_area = "SELECT * FROM m_area ORDER BY nama ASC";
                                $stmt_area = $conn->prepare($sql_area);
                                $stmt_area->execute();
                                while($row_area = $stmt_area->fetch(PDO::FETCH_ASSOC)){
                                    echo '<option value="'.$row_area['id'].'">'.$row_area['nama'].'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Pit <span class="text-danger">*</span></label>
                            <select class="form-control select2" name="pit_id" id="add_pit_id" required style="width: 100%;">
                                <option value="">Pilih Area Terlebih Dahulu</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Nama ROM <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="nama" required placeholder="Nama ROM">
                        </div>
                        <div class="form-group">
                            <label>Deskripsi</label>
                            <textarea class="form-control" name="des" rows="3" placeholder="Deskripsi"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status">
                                <option value="1">Aktif</option>
                                <option value="0">Tidak Aktif</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="modal-edit">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="form-edit">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Edit ROM</h4>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Area <span class="text-danger">*</span></label>
                            <select class="form-control select2" name="area_id" id="edit_area_id" required style="width: 100%;">
                                <option value="">Pilih Area</option>
                                <?php
                                // Re-fetch areas for edit modal
                                $stmt_area->execute();
                                while($row_area = $stmt_area->fetch(PDO::FETCH_ASSOC)){
                                    echo '<option value="'.$row_area['id'].'">'.$row_area['nama'].'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Pit <span class="text-danger">*</span></label>
                            <select class="form-control select2" name="pit_id" id="edit_pit_id" required style="width: 100%;">
                                <option value="">Pilih Area Terlebih Dahulu</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Nama ROM <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="nama" id="edit_nama" required placeholder="Nama ROM">
                        </div>
                        <div class="form-group">
                            <label>Deskripsi</label>
                            <textarea class="form-control" name="des" id="edit_des" rows="3" placeholder="Deskripsi"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status" id="edit_status">
                                <option value="1">Aktif</option>
                                <option value="0">Tidak Aktif</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>
<!-- ./wrapper -->

<script>
$(document).ready(function() {
    // Helper to load Pits
    function loadPits(areaId, targetSelector, selectedPitId = null) {
        if(!areaId) {
            $(targetSelector).html('<option value="">Pilih Area Terlebih Dahulu</option>').trigger('change');
            return;
        }
        
        $.ajax({
            url: '../../controller/RomController.php?action=get_pit_by_area',
            type: 'GET',
            data: { area_id: areaId },
            dataType: 'json',
            success: function(data) {
                var options = '<option value="">Pilih Pit</option>';
                if(data.status === 'error') {
                    alert('Error loading pits');
                } else {
                    $.each(data, function(index, item) {
                        var selected = (selectedPitId && selectedPitId == item.id) ? 'selected' : '';
                        options += '<option value="' + item.id + '" ' + selected + '>' + item.nama + '</option>';
                    });
                    $(targetSelector).html(options).trigger('change');
                }
            }
        });
    }

    // Add Modal Area Change
    $('#add_area_id').change(function() {
        var areaId = $(this).val();
        loadPits(areaId, '#add_pit_id');
    });

    // Edit Modal Area Change
    $('#edit_area_id').change(function() {
        var areaId = $(this).val();
        loadPits(areaId, '#edit_pit_id');
    });

    // Add Form Submit
    $('#form-add').submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/RomController.php?action=create',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert(response.message);
                }
            }
        });
    });

    // Edit Button Click
    $('.btn-edit').click(function() {
        var id = $(this).data('id');
        var area_id = $(this).data('area_id');
        var pit_id = $(this).data('pit_id');
        var nama = $(this).data('nama');
        var des = $(this).data('des');
        var status = $(this).data('status');

        $('#edit_id').val(id);
        $('#edit_area_id').val(area_id).trigger('change');
        // Wait for area to change then trigger pit load
        // But since ajax is async, we do it in a hacky way or pass selectedPitId to loadPits
        // We modified loadPits to accept selectedPitId
        loadPits(area_id, '#edit_pit_id', pit_id);
        
        $('#edit_nama').val(nama);
        $('#edit_des').val(des);
        $('#edit_status').val(status);
        $('#modal-edit').modal('show');
    });

    // Edit Form Submit
    $('#form-edit').submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/RomController.php?action=update',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert(response.message);
                }
            }
        });
    });

    // Delete Button Click
    $('.btn-delete').click(function() {
        if(confirm('Apakah anda yakin ingin menghapus data ini?')) {
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/RomController.php?action=delete',
                type: 'POST',
                data: {id: id},
                dataType: 'json',
                success: function(response) {
                    if(response.status == 'success') {
                        alert(response.message);
                        location.reload();
                    } else {
                        alert(response.message);
                    }
                }
            });
        }
    });

    // Initialize Select2
    $('.select2').select2();
});
</script>
</body>
</html>
