<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Ketercapaian Target Jan-26</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            padding: 30px;
        }

        .chart-container {
            width: 900px;
            margin: auto;
            background: #ffffff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<div class="chart-container">
    <h2>Ketercapaian Target Periode Jan-26</h2>
    <canvas id="targetChart"></canvas>
</div>

<script>
const labels = ['WEEK 1', 'WEEK 2', 'WEEK 3', 'WEEK 4'];

// Dummy Data
const planData   = [2583.45, 4843.97, 2583.45, 7104.49];
const actualData = [318.59, 5344.46, 318.59, 3278.60];

// Hitung persentase
const percentData = actualData.map((val, i) =>
    Math.round((val / planData[i]) * 100)
);

const ctx = document.getElementById('targetChart').getContext('2d');

new Chart(ctx, {
    type: 'bar',
    data: {
        labels: labels,
        datasets: [
            {
                label: 'PLAN',
                data: planData,
                backgroundColor: '#5B9BD5',
                yAxisID: 'y'
            },
            {
                label: 'AKTUAL',
                data: actualData,
                backgroundColor: '#ED7D31',
                yAxisID: 'y'
            },
            {
                label: '%',
                data: percentData,
                type: 'line',
                borderColor: '#A6A6A6',
                backgroundColor: '#A6A6A6',
                yAxisID: 'y1',
                tension: 0.4,
                pointBackgroundColor: '#000',
                pointRadius: 5
            }
        ]
    },
    options: {
        responsive: true,
        interaction: {
            mode: 'index',
            intersect: false
        },
        scales: {
            y: {
                beginAtZero: true,
                position: 'left',
                title: {
                    display: true,
                    text: 'Nilai'
                }
            },
            y1: {
                beginAtZero: true,
                position: 'right',
                max: 120,
                ticks: {
                    callback: value => value + '%'
                },
                title: {
                    display: true,
                    text: 'Persentase'
                },
                grid: {
                    drawOnChartArea: false
                }
            }
        },
        plugins: {
            tooltip: {
                callbacks: {
                    label: function(ctx) {
                        if (ctx.dataset.label === '%') {
                            return ctx.parsed.y + '%';
                        }
                        return ctx.parsed.y.toLocaleString();
                    }
                }
            },
            legend: {
                position: 'bottom'
            }
        }
    }
});
</script>

</body>
</html>
