<?php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

$sqlArea = "SELECT * FROM m_area ORDER BY nama ASC";
$stmtArea = $conn->prepare($sqlArea);
$stmtArea->execute();
$areaList = $stmtArea->fetchAll(PDO::FETCH_ASSOC);

$sqlMaterial = "SELECT * FROM m_material ORDER BY nama ASC";
$stmtMaterial = $conn->prepare($sqlMaterial);
$stmtMaterial->execute();
$materialList = $stmtMaterial->fetchAll(PDO::FETCH_ASSOC);

$sqlDT = "SELECT h.*, t.nama as type_nama FROM m_heq h 
          LEFT JOIN m_type_unit t ON h.type_id = t.id 
          WHERE t.nama = 'Dumptruck' 
          ORDER BY h.no_unit ASC";
$stmtDT = $conn->prepare($sqlDT);
$stmtDT->execute();
$dtList = $stmtDT->fetchAll(PDO::FETCH_ASSOC);

$sqlExca = "SELECT h.*, t.nama as type_nama FROM m_heq h 
            LEFT JOIN m_type_unit t ON h.type_id = t.id 
            WHERE t.nama = 'Excavator' 
            ORDER BY h.no_unit ASC";
$stmtExca = $conn->prepare($sqlExca);
$stmtExca->execute();
$excaList = $stmtExca->fetchAll(PDO::FETCH_ASSOC);

// Get Driver Dump users (level_id = 3)
$sqlDrivers = "SELECT id, nama FROM m_user WHERE level_id = 3 AND status_aktif = 1 ORDER BY nama ASC";
$stmtDrivers = $conn->prepare($sqlDrivers);
$stmtDrivers->execute();
$driverList = $stmtDrivers->fetchAll(PDO::FETCH_ASSOC);

// Get Operator Exca users (level_id = 4)
$sqlOperators = "SELECT id, nama FROM m_user WHERE level_id = 4 AND status_aktif = 1 ORDER BY nama ASC";
$stmtOperators = $conn->prepare($sqlOperators);
$stmtOperators->execute();
$operatorList = $stmtOperators->fetchAll(PDO::FETCH_ASSOC);

$statusLabels = [
    0 => ['label' => 'Open', 'class' => 'label-default'],
    1 => ['label' => 'Pergi', 'class' => 'label-info'],
    2 => ['label' => 'Sampai', 'class' => 'label-warning'],
    3 => ['label' => 'Selesai', 'class' => 'label-success']
];
?>

<style>
.status-btn { margin: 2px; }
.info-box-number { font-size: 24px; }

/* DataTables Pagination - Clean Style */
.dataTables_wrapper .dataTables_paginate {
    padding: 15px 0;
    float: right;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    display: inline-block;
    padding: 6px 12px;
    margin: 0 2px;
    border-radius: 4px;
    background: #333;
    border: 1px solid #555;
    color: #fff !important;
    cursor: pointer;
    font-size: 14px;
    text-decoration: none;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: #ff9900;
    border-color: #ff9900;
    color: #000 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: #ff9900 !important;
    border-color: #ff9900 !important;
    color: #000 !important;
    font-weight: 600;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover {
    background: #222 !important;
    border-color: #333 !important;
    color: #555 !important;
    cursor: default;
}

/* DataTables Length & Search */
.dataTables_wrapper .dataTables_length {
    float: left;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length label {
    color: #ccc;
}

.dataTables_wrapper .dataTables_length select {
    padding: 5px 10px;
    border-radius: 4px;
    margin: 0 5px;
    min-width: 60px;
}

.dataTables_wrapper .dataTables_filter {
    float: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    padding: 6px 15px;
    border-radius: 15px;
    border: 1px solid #555;
    margin-left: 8px;
    min-width: 200px;
}

/* DataTables Info */
.dataTables_wrapper .dataTables_info {
    float: left;
    padding: 15px 0;
    color: #aaa;
    font-size: 13px;
}

/* Clear float */
.dataTables_wrapper::after {
    content: "";
    display: table;
    clear: both;
}

.loading-spinner {
    text-align: center;
    padding: 20px;
    color: #ff9900;
}

/* Date Range Filter Section */
.filter-section {
    display: flex;
    gap: 10px;
    align-items: center;
    flex-wrap: wrap;
}

.filter-group {
    display: flex;
    align-items: center;
    gap: 5px;
}

.filter-label {
    color: #ff9900 !important;
    font-size: 12px;
    font-weight: 600;
    margin: 0 !important;
    white-space: nowrap;
}

.filter-input {
    width: 150px !important;
    padding: 6px 10px !important;
    border-radius: 6px !important;
    font-size: 13px !important;
}

.filter-input::-webkit-calendar-picker-indicator {
    filter: invert(1);
    cursor: pointer;
}

/* Active Filter Indicator */
.filter-active {
    position: relative;
}

.filter-active::after {
    content: '';
    position: absolute;
    top: -3px;
    right: -3px;
    width: 8px;
    height: 8px;
    background: #28a745;
    border-radius: 50%;
}

/* Filter Summary Badge */
.filter-summary {
    background: rgba(255, 153, 0, 0.2);
    color: #ff9900;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 13px;
    margin-bottom: 15px;
    display: none;
}

.filter-summary.active {
    display: inline-block;
}

.filter-summary .close-filter {
    margin-left: 10px;
    cursor: pointer;
    opacity: 0.7;
}

.filter-summary .close-filter:hover {
    opacity: 1;
}

/* Table Improvements */
.table > tbody > tr > td {
    vertical-align: middle !important;
}

/* Select2 Dark Theme */
.select2-container--default .select2-selection--single {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
    height: 38px !important;
    padding: 4px 8px !important;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff !important;
    line-height: 28px !important;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
}
.select2-container--default .select2-dropdown {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
}
.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: #1e1e1e !important;
    border: 1px solid #555 !important;
    color: #fff !important;
}
.select2-container--default .select2-results__option {
    color: #ccc !important;
    background-color: #2c2c2c !important;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #3a3a3a !important;
    color: #ff9900 !important;
}
.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: #ff9900 !important;
    color: #000 !important;
}
.modal-open .select2-container--open { z-index: 10060 !important; }
.modal-open .select2-dropdown { z-index: 10060 !important; }
.modal .modal-body { overflow: visible; }
.modal .modal-content { overflow: visible; }

/* Responsive Filter */
@media (max-width: 992px) {
    .filter-section {
        width: 100%;
        margin-top: 10px;
        justify-content: flex-start;
    }
    
    .filter-group {
        margin-bottom: 5px;
    }
    
    .filter-input {
        width: 130px !important;
    }
}

@media (max-width: 576px) {
    .filter-section {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .filter-group {
        width: 100%;
    }
    
    .filter-input {
        width: 100% !important;
        flex: 1;
    }
    
    #applyFilter, #resetFilter {
        width: 48%;
    }
}
</style>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Process
        <small>Point of Production (POP)</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Process</li>
        <li class="active">POP</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-aqua">
            <span class="info-box-icon"><i class="fa fa-truck"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Ritase Hari Ini</span>
              <span class="info-box-number">
                <?php 
                $today = date('Y-m-d');
                $sqlCount = "SELECT COUNT(*) FROM m_pop WHERE tanggal = :today";
                $stmtCount = $conn->prepare($sqlCount);
                $stmtCount->execute([':today' => $today]);
                echo $stmtCount->fetchColumn();
                ?>
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-green">
            <span class="info-box-icon"><i class="fa fa-check"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Selesai</span>
              <span class="info-box-number">
                <?php 
                $sqlSelesai = "SELECT COUNT(*) FROM m_pop WHERE tanggal = :today AND status = 3";
                $stmtSelesai = $conn->prepare($sqlSelesai);
                $stmtSelesai->execute([':today' => $today]);
                echo $stmtSelesai->fetchColumn();
                ?>
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-yellow">
            <span class="info-box-icon"><i class="fa fa-hourglass-half"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Dalam Perjalanan</span>
              <span class="info-box-number">
                <?php 
                $sqlProses = "SELECT COUNT(*) FROM m_pop WHERE tanggal = :today AND status IN (1,2)";
                $stmtProses = $conn->prepare($sqlProses);
                $stmtProses->execute([':today' => $today]);
                echo $stmtProses->fetchColumn();
                ?>
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-red">
            <span class="info-box-icon"><i class="fa fa-cube"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Tonase Hari Ini</span>
              <span class="info-box-number">
                <?php 
                $sqlTonase = "SELECT COALESCE(SUM(jml_tonase),0) FROM m_pop WHERE tanggal = :today";
                $stmtTonase = $conn->prepare($sqlTonase);
                $stmtTonase->execute([':today' => $today]);
                echo number_format($stmtTonase->fetchColumn(), 2);
                ?> Ton
              </span>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah POP</button>
                    
                    <!-- Filter Section -->
                    <div class="pull-right filter-section">
                        <div class="filter-group">
                            <label class="filter-label"><i class="fa fa-calendar"></i> Dari:</label>
                            <input type="date" id="filterTanggalDari" class="form-control filter-input" title="Tanggal Mulai">
                        </div>
                        <div class="filter-group">
                            <label class="filter-label">Sampai:</label>
                            <input type="date" id="filterTanggalSampai" class="form-control filter-input" title="Tanggal Akhir">
                        </div>
                        <button type="button" id="applyFilter" class="btn btn-warning" title="Terapkan Filter">
                            <i class="fa fa-filter"></i> Filter
                        </button>
                        <button type="button" id="resetFilter" class="btn btn-default" title="Reset Filter">
                            <i class="fa fa-refresh"></i> Reset
                        </button>
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    </div>
                </div>
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="3%">No</th>
                      <th>Tanggal</th>
                      <th>Area</th>
                      <th>Pit</th>
                      <th>Dump Truck</th>
                      <th>Excavator</th>
                      <th>Material</th>
                      <th>Jam Datang</th>
                      <th>Jam Berangkat</th>
                      <th>Jam Sampai</th>
                      <th>Bucket</th>
                      <th>Tonase</th>
                      <th>Status</th>
                      <th width="10%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT p.*, 
                            a.nama as area_nama, 
                            pt.nama as pit_nama, 
                            COALESCE(dt.nama_unit, dt.no_unit) as dt_nama, 
                            COALESCE(ex.nama_unit, ex.no_unit) as exca_nama,
                            m.nama as material_nama,
                            m.kode as material_kode
                            FROM m_pop p 
                            LEFT JOIN m_area a ON p.area_id = a.id 
                            LEFT JOIN m_pit pt ON p.pit_id = pt.id 
                            LEFT JOIN m_heq dt ON p.dt_id = dt.id 
                            LEFT JOIN m_heq ex ON p.exca_id = ex.id 
                            LEFT JOIN m_material m ON p.material_id = m.id 
                            ORDER BY p.id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $statusInfo = $statusLabels[$row['status']] ?? $statusLabels[0];
                    ?>
                    <tr data-date="<?php echo $row['tanggal']; ?>">
                      <td><?php echo $no++; ?></td>
                      <td data-order="<?php echo $row['tanggal']; ?>"><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                      <td><?php echo htmlspecialchars($row['area_nama'] ?? '-'); ?></td>
                      <td><?php echo htmlspecialchars($row['pit_nama'] ?? '-'); ?></td>
                      <td><b><?php echo htmlspecialchars($row['dt_nama'] ?? '-'); ?></b></td>
                      <td><?php echo htmlspecialchars($row['exca_nama'] ?? '-'); ?></td>
                      <td><span class="badge" style="background-color:#3c8dbc;"><?php echo htmlspecialchars($row['material_kode'] ?? '-'); ?></span> <?php echo htmlspecialchars($row['material_nama'] ?? ''); ?></td>
                      <td><?php echo $row['jam_datang'] ? date('H:i', strtotime($row['jam_datang'])) : '-'; ?></td>
                      <td><?php echo $row['jam_berangkat'] ? date('H:i', strtotime($row['jam_berangkat'])) : '-'; ?></td>
                      <td><?php echo $row['jam_sampai'] ? date('H:i', strtotime($row['jam_sampai'])) : '-'; ?></td>
                      <td><?php echo $row['jml_bucket']; ?></td>
                      <td><b><?php echo number_format($row['jml_tonase'], 2); ?></b></td>
                      <td><span class="label <?php echo $statusInfo['class']; ?>"><?php echo $statusInfo['label']; ?></span></td>
                      <td>
                          <?php if($row['status'] == 0): ?>
                          <button class="btn btn-info btn-xs status-btn" data-id="<?php echo $row['id']; ?>" data-status="1" title="Set Pergi"><i class="fa fa-truck"></i></button>
                          <?php endif; ?>
                          <?php if($row['status'] == 1): ?>
                          <button class="btn btn-warning btn-xs status-btn" data-id="<?php echo $row['id']; ?>" data-status="2" title="Set Sampai"><i class="fa fa-flag"></i></button>
                          <?php endif; ?>
                          <?php if($row['status'] == 2): ?>
                          <button class="btn btn-success btn-xs status-btn" data-id="<?php echo $row['id']; ?>" data-status="3" title="Set Selesai"><i class="fa fa-check"></i></button>
                          <?php endif; ?>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i></button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i></button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>
        </div>
      </div>
    </section>
</div>

<div class="modal fade" id="addModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Tambah POP</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Tanggal</label>
                <input type="date" name="tanggal" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Jam Datang</label>
                <input type="time" name="jam_datang" class="form-control" value="<?php echo date('H:i'); ?>" required>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Area</label>
                <select name="area_id" id="add_area_id" class="form-control select2-pop" style="width:100%;" required>
                    <option value="">-- Pilih Area --</option>
                    <?php foreach($areaList as $area): ?>
                    <option value="<?php echo $area['id']; ?>"><?php echo htmlspecialchars($area['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Pit</label>
                <select name="pit_id" id="add_pit_id" class="form-control select2-pop" style="width:100%;" required>
                    <option value="">-- Pilih Pit --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>ROM (Run Of Mine)</label>
                <select name="rom_id" id="add_rom_id" class="form-control select2-pop" style="width:100%;">
                    <option value="">-- Pilih ROM --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Dump Truck</label>
                <select name="dt_id" id="add_dt_id" class="form-control select2-pop" style="width:100%;" required>
                    <option value="">-- Pilih Dump Truck --</option>
                    <?php foreach($dtList as $dt): ?>
                    <option value="<?php echo $dt['id']; ?>"><?php echo htmlspecialchars($dt['no_unit'] . ($dt['nama_unit'] ? ' - '.$dt['nama_unit'] : '')); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Excavator</label>
                <select name="exca_id" id="add_exca_id" class="form-control select2-pop" style="width:100%;" required>
                    <option value="">-- Pilih Excavator --</option>
                    <?php foreach($excaList as $exca): ?>
                    <option value="<?php echo $exca['id']; ?>"><?php echo htmlspecialchars($exca['no_unit'] . ($exca['nama_unit'] ? ' - '.$exca['nama_unit'] : '')); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Driver Dump Truck</label>
                <select name="driver_id" id="add_driver_id" class="form-control select2-pop" style="width:100%;">
                    <option value="">-- Pilih Driver Dump Truck --</option>
                    <?php foreach($driverList as $driver): ?>
                    <option value="<?php echo $driver['id']; ?>"><?php echo htmlspecialchars($driver['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Operator Excavator</label>
                <select name="operator_id" id="add_operator_id" class="form-control select2-pop" style="width:100%;">
                    <option value="">-- Pilih Operator Excavator --</option>
                    <?php foreach($operatorList as $operator): ?>
                    <option value="<?php echo $operator['id']; ?>"><?php echo htmlspecialchars($operator['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Material</label>
                <select name="material_id" id="add_material_id" class="form-control select2-pop" style="width:100%;" required>
                    <option value="">-- Pilih Material --</option>
                    <?php foreach($materialList as $mat): ?>
                    <option value="<?php echo $mat['id']; ?>">[<?php echo htmlspecialchars($mat['kode']); ?>] <?php echo htmlspecialchars($mat['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
                <label>Jumlah Bucket</label>
                <input type="number" name="jml_bucket" class="form-control" value="0" min="0">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
                <label>Jumlah Tonase</label>
                <input type="number" name="jml_tonase" class="form-control" value="0" min="0" step="0.01">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-4">
            <div class="form-group">
                <label>Jam Berangkat</label>
                <input type="time" name="jam_berangkat" class="form-control">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
                <label>Jam Sampai</label>
                <input type="time" name="jam_sampai" class="form-control">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control">
                    <option value="0">Open</option>
                    <option value="1">Pergi</option>
                    <option value="2">Sampai</option>
                    <option value="3">Selesai</option>
                </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Edit POP</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Tanggal</label>
                <input type="date" name="tanggal" id="edit_tanggal" class="form-control" required>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Jam Datang</label>
                <input type="time" name="jam_datang" id="edit_jam_datang" class="form-control" required>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Area</label>
                <select name="area_id" id="edit_area_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Area --</option>
                    <?php foreach($areaList as $area): ?>
                    <option value="<?php echo $area['id']; ?>"><?php echo htmlspecialchars($area['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Pit</label>
                <select name="pit_id" id="edit_pit_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Pit --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>ROM (Run Of Mine)</label>
                <select name="rom_id" id="edit_rom_id" class="form-control select2-edit" style="width:100%;">
                    <option value="">-- Pilih ROM --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Dump Truck</label>
                <select name="dt_id" id="edit_dt_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Dump Truck --</option>
                    <?php foreach($dtList as $dt): ?>
                    <option value="<?php echo $dt['id']; ?>"><?php echo htmlspecialchars($dt['no_unit'] . ($dt['nama_unit'] ? ' - '.$dt['nama_unit'] : '')); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Excavator</label>
                <select name="exca_id" id="edit_exca_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Excavator --</option>
                    <?php foreach($excaList as $exca): ?>
                    <option value="<?php echo $exca['id']; ?>"><?php echo htmlspecialchars($exca['no_unit'] . ($exca['nama_unit'] ? ' - '.$exca['nama_unit'] : '')); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Driver Dump Truck</label>
                <select name="driver_id" id="edit_driver_id" class="form-control select2-edit" style="width:100%;">
                    <option value="">-- Pilih Driver Dump Truck --</option>
                    <?php foreach($driverList as $driver): ?>
                    <option value="<?php echo $driver['id']; ?>"><?php echo htmlspecialchars($driver['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Operator Excavator</label>
                <select name="operator_id" id="edit_operator_id" class="form-control select2-edit" style="width:100%;">
                    <option value="">-- Pilih Operator Excavator --</option>
                    <?php foreach($operatorList as $operator): ?>
                    <option value="<?php echo $operator['id']; ?>"><?php echo htmlspecialchars($operator['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Material</label>
                <select name="material_id" id="edit_material_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Material --</option>
                    <?php foreach($materialList as $mat): ?>
                    <option value="<?php echo $mat['id']; ?>">[<?php echo htmlspecialchars($mat['kode']); ?>] <?php echo htmlspecialchars($mat['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
                <label>Jumlah Bucket</label>
                <input type="number" name="jml_bucket" id="edit_jml_bucket" class="form-control" min="0">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
                <label>Jumlah Tonase</label>
                <input type="number" name="jml_tonase" id="edit_jml_tonase" class="form-control" min="0" step="0.01">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-4">
            <div class="form-group">
                <label>Jam Berangkat</label>
                <input type="time" name="jam_berangkat" id="edit_jam_berangkat" class="form-control">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
                <label>Jam Sampai</label>
                <input type="time" name="jam_sampai" id="edit_jam_sampai" class="form-control">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
                <label>Status</label>
                <select name="status" id="edit_status" class="form-control">
                    <option value="0">Open</option>
                    <option value="1">Pergi</option>
                    <option value="2">Sampai</option>
                    <option value="3">Selesai</option>
                </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    var popTable = $('#example1').DataTable({
        "ordering": true,
        "order": [[1, 'desc'], [0, 'desc']],
        "pageLength": 25,
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Semua"]],
        "processing": true,
        "stateSave": true,
        "pagingType": "simple_numbers",
        "language": {
            "search": "Cari:",
            "searchPlaceholder": "Ketik untuk mencari...",
            "lengthMenu": "Tampilkan _MENU_ data per halaman",
            "info": "Menampilkan _START_ - _END_ dari _TOTAL_ data",
            "infoEmpty": "Tidak ada data tersedia",
            "infoFiltered": "(difilter dari _MAX_ total data)",
            "zeroRecords": "Tidak ada data yang cocok",
            "emptyTable": "Belum ada data POP",
            "processing": "<i class='fa fa-spinner fa-spin'></i> Memuat...",
            "paginate": { 
                "first": "«", 
                "last": "»", 
                "next": "›", 
                "previous": "‹" 
            }
        },
        "columnDefs": [
            { "orderable": false, "targets": [13] },
            { "className": "text-center", "targets": [0, 7, 8, 9, 10, 12, 13] }
        ],
        "drawCallback": function(settings) {
            // Rebind event handlers after table redraw (pagination)
            bindStatusButtons();
            bindEditButtons();
            bindDeleteButtons();
        }
    });

    // Custom date range filter using DataTables ext search
    var minDate = null;
    var maxDate = null;

    // Custom filtering function
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
        // Only apply to our table
        if (settings.nTable.id !== 'example1') {
            return true;
        }

        // Get the date from the row (data-date attribute)
        var rowDate = $(popTable.row(dataIndex).node()).data('date');
        
        if (!rowDate) return true;
        
        // If no filter is set, show all
        if (!minDate && !maxDate) {
            return true;
        }

        // Parse dates for comparison
        var rowDateObj = new Date(rowDate);
        var minDateObj = minDate ? new Date(minDate) : null;
        var maxDateObj = maxDate ? new Date(maxDate) : null;

        // Reset time portion for accurate date comparison
        rowDateObj.setHours(0, 0, 0, 0);
        if (minDateObj) minDateObj.setHours(0, 0, 0, 0);
        if (maxDateObj) maxDateObj.setHours(0, 0, 0, 0);

        // Check range
        if (minDateObj && maxDateObj) {
            return rowDateObj >= minDateObj && rowDateObj <= maxDateObj;
        } else if (minDateObj) {
            return rowDateObj >= minDateObj;
        } else if (maxDateObj) {
            return rowDateObj <= maxDateObj;
        }

        return true;
    });

    // Apply Filter button
    $('#applyFilter').on('click', function() {
        minDate = $('#filterTanggalDari').val();
        maxDate = $('#filterTanggalSampai').val();

        // Validate: end date should not be before start date
        if (minDate && maxDate && new Date(maxDate) < new Date(minDate)) {
            alert('Tanggal akhir tidak boleh lebih kecil dari tanggal awal!');
            return;
        }

        // Redraw table with filter
        popTable.draw();

        // Update filter summary
        updateFilterSummary();
    });

    // Also filter on Enter key
    $('#filterTanggalDari, #filterTanggalSampai').on('keypress', function(e) {
        if (e.which === 13) {
            $('#applyFilter').click();
        }
    });

    // Reset filter
    $('#resetFilter').on('click', function() {
        $('#filterTanggalDari').val('');
        $('#filterTanggalSampai').val('');
        minDate = null;
        maxDate = null;
        popTable.draw();
        updateFilterSummary();
    });

    // Function to update filter summary badge
    function updateFilterSummary() {
        var $summary = $('.filter-summary');
        if (!$summary.length) {
            // Create summary element if not exists
            $('.box-body').prepend('<div class="filter-summary"><i class="fa fa-filter"></i> <span class="filter-text"></span><span class="close-filter"><i class="fa fa-times"></i></span></div>');
            $summary = $('.filter-summary');
            
            // Bind close button
            $summary.find('.close-filter').on('click', function() {
                $('#resetFilter').click();
            });
        }

        if (minDate || maxDate) {
            var text = 'Filter aktif: ';
            if (minDate && maxDate) {
                text += formatDateID(minDate) + ' s/d ' + formatDateID(maxDate);
            } else if (minDate) {
                text += 'Dari ' + formatDateID(minDate);
            } else if (maxDate) {
                text += 'Sampai ' + formatDateID(maxDate);
            }
            $summary.find('.filter-text').text(text);
            $summary.addClass('active');
        } else {
            $summary.removeClass('active');
        }
    }

    // Helper function to format date in Indonesian format
    function formatDateID(dateStr) {
        var date = new Date(dateStr);
        var day = String(date.getDate()).padStart(2, '0');
        var month = String(date.getMonth() + 1).padStart(2, '0');
        var year = date.getFullYear();
        return day + '/' + month + '/' + year;
    }

    // Function to bind status buttons
    function bindStatusButtons() {
        $('.status-btn').off('click').on('click', function(){
            var id = $(this).data('id');
            var status = $(this).data('status');
            var statusText = {1: 'Pergi', 2: 'Sampai', 3: 'Selesai'};
            if(confirm('Ubah status menjadi "'+statusText[status]+'"?')){
                $.ajax({
                    url: '../../controller/PopController.php?action=update_status',
                    method: 'POST',
                    data: {id: id, status: status},
                    success: function(res){
                        try {
                            var data = JSON.parse(res);
                            if(data.status == 'success'){
                                location.reload();
                            } else {
                                alert(data.message);
                            }
                        } catch(e) {
                            alert('Error parsing response');
                        }
                    }
                });
            }
        });
    }

    // Function to bind edit buttons
    function bindEditButtons() {
        $('.edit-btn').off('click').on('click', function(){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/PopController.php?action=get',
                method: 'GET',
                data: {id: id},
                dataType: 'json',
                success: function(data){
                    $('#edit_id').val(data.id);
                    $('#edit_tanggal').val(data.tanggal);
                    $('#edit_jam_datang').val(data.jam_datang);
                    $('#edit_area_id').val(data.area_id).trigger('change');
                    setTimeout(function(){
                        $('#edit_pit_id').val(data.pit_id).trigger('change');
                        setTimeout(function(){
                            if(data.rom_id) {
                                $('#edit_rom_id').val(data.rom_id).trigger('change');
                            }
                        }, 600);
                    }, 500);
                    $('#edit_dt_id').val(data.dt_id).trigger('change');
                    $('#edit_exca_id').val(data.exca_id).trigger('change');
                    $('#edit_driver_id').val(data.driver_id).trigger('change');
                    $('#edit_operator_id').val(data.operator_id).trigger('change');
                    $('#edit_material_id').val(data.material_id).trigger('change');
                    $('#edit_jml_bucket').val(data.jml_bucket);
                    $('#edit_jml_tonase').val(data.jml_tonase);
                    $('#edit_jam_berangkat').val(data.jam_berangkat);
                    $('#edit_jam_sampai').val(data.jam_sampai);
                    $('#edit_status').val(data.status);
                    $('#editModal').modal('show');
                }
            });
        });
    }

    // Function to bind delete buttons
    function bindDeleteButtons() {
        $('.delete-btn').off('click').on('click', function(){
            if(confirm('Yakin ingin menghapus data ini?')){
                var id = $(this).data('id');
                $.ajax({
                    url: '../../controller/PopController.php?action=delete',
                    method: 'POST',
                    data: {id: id},
                    success: function(res){
                        try {
                            var data = JSON.parse(res);
                            if(data.status == 'success'){
                                alert(data.message);
                                location.reload();
                            } else {
                                alert(data.message);
                            }
                        } catch(e) {
                            alert('Error parsing response');
                        }
                    }
                });
            }
        });
    }

    // Initial binding
    bindStatusButtons();
    bindEditButtons();
    bindDeleteButtons();

    var select2Config = {
        allowClear: true,
        width: '100%'
    };

    $('#addModal').on('shown.bs.modal', function() {
        $('#add_area_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Area --' }));
        $('#add_pit_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Pit --' }));
        $('#add_rom_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih ROM --' }));
        $('#add_dt_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Dump Truck --' }));
        $('#add_exca_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Excavator --' }));
        $('#add_driver_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Driver --' }));
        $('#add_operator_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Operator --' }));
        $('#add_material_id').select2($.extend({}, select2Config, { dropdownParent: $('#addModal .modal-body'), placeholder: '-- Pilih Material --' }));
    });

    $('#editModal').on('shown.bs.modal', function() {
        $('#edit_area_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Area --' }));
        $('#edit_pit_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Pit --' }));
        $('#edit_rom_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih ROM --' }));
        $('#edit_dt_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Dump Truck --' }));
        $('#edit_exca_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Excavator --' }));
        $('#edit_driver_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Driver --' }));
        $('#edit_operator_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Operator --' }));
        $('#edit_material_id').select2($.extend({}, select2Config, { dropdownParent: $('#editModal .modal-body'), placeholder: '-- Pilih Material --' }));
    });

    $('#addModal').on('hidden.bs.modal', function() {
        $('#addForm')[0].reset();
        if ($('#add_area_id').hasClass('select2-hidden-accessible')) {
            $('#add_area_id').val('').trigger('change');
            $('#add_pit_id').html('<option value="">-- Pilih Pit --</option>').trigger('change');
            $('#add_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
            $('#add_dt_id').val('').trigger('change');
            $('#add_exca_id').val('').trigger('change');
            $('#add_driver_id').val('').trigger('change');
            $('#add_operator_id').val('').trigger('change');
            $('#add_material_id').val('').trigger('change');
        }
    });

    $('#add_area_id').on('change', function(){
        var area_id = $(this).val();
        if(area_id) {
            $.ajax({
                url: '../../controller/PopController.php?action=get_pit_by_area',
                method: 'GET',
                data: {area_id: area_id},
                dataType: 'json',
                success: function(data){
                    var options = '<option value="">-- Pilih Pit --</option>';
                    data.forEach(function(pit){
                        options += '<option value="'+pit.id+'">'+pit.nama+'</option>';
                    });
                    $('#add_pit_id').html(options).trigger('change');
                    // Reset ROM when area changes
                    $('#add_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
                }
            });
        } else {
            $('#add_pit_id').html('<option value="">-- Pilih Pit --</option>').trigger('change');
            $('#add_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
        }
    });

    // Add Pit change - load ROM
    $('#add_pit_id').on('change', function(){
        var pit_id = $(this).val();
        if(pit_id) {
            $.ajax({
                url: '../../controller/PopController.php?action=get_rom_by_pit',
                method: 'GET',
                data: {pit_id: pit_id},
                dataType: 'json',
                success: function(data){
                    var options = '<option value="">-- Pilih ROM --</option>';
                    data.forEach(function(rom){
                        options += '<option value="'+rom.id+'">'+rom.nama+'</option>';
                    });
                    $('#add_rom_id').html(options).trigger('change');
                }
            });
        } else {
            $('#add_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
        }
    });

    $('#edit_area_id').on('change', function(){
        var area_id = $(this).val();
        if(area_id) {
            $.ajax({
                url: '../../controller/PopController.php?action=get_pit_by_area',
                method: 'GET',
                data: {area_id: area_id},
                dataType: 'json',
                success: function(data){
                    var options = '<option value="">-- Pilih Pit --</option>';
                    data.forEach(function(pit){
                        options += '<option value="'+pit.id+'">'+pit.nama+'</option>';
                    });
                    $('#edit_pit_id').html(options);
                    // Reset ROM when area changes
                    $('#edit_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
                }
            });
        }
    });

    // Edit Pit change - load ROM
    $('#edit_pit_id').on('change', function(){
        var pit_id = $(this).val();
        if(pit_id) {
            $.ajax({
                url: '../../controller/PopController.php?action=get_rom_by_pit',
                method: 'GET',
                data: {pit_id: pit_id},
                dataType: 'json',
                success: function(data){
                    var options = '<option value="">-- Pilih ROM --</option>';
                    data.forEach(function(rom){
                        options += '<option value="'+rom.id+'">'+rom.nama+'</option>';
                    });
                    $('#edit_rom_id').html(options);
                }
            });
        } else {
            $('#edit_rom_id').html('<option value="">-- Pilih ROM --</option>').trigger('change');
        }
    });

    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/PopController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    alert('Error parsing response');
                }
            }
        });
    });

    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/PopController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    alert('Error parsing response');
                }
            }
        });
    });

});

</script>
