<?php
// view/m_pit/index.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Fetch Areas for dropdown
$sql_areas = "SELECT * FROM m_area ORDER BY nama ASC";
$stmt_areas = $conn->prepare($sql_areas);
$stmt_areas->execute();
$areas = $stmt_areas->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Master Data
        <small>Pit</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Master Data</li>
        <li class="active">Pit</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Pit</button>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="5%">No</th>
                      <th>Area</th>
                      <th>Nama Pit</th>
                      <th>Deskripsi</th>
                      <th>Status</th>
                      <th width="15%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT p.*, a.nama as nama_area 
                            FROM m_pit p 
                            LEFT JOIN m_area a ON p.area_id = a.id 
                            ORDER BY p.id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $status_label = $row['status'] == 1 ? '<span class="label label-success">Aktif</span>' : '<span class="label label-danger">Tidak Aktif</span>';
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><?php echo htmlspecialchars($row['nama_area']); ?></td>
                      <td><b><?php echo htmlspecialchars($row['nama']); ?></b></td>
                      <td><?php echo htmlspecialchars($row['des']); ?></td>
                      <td><?php echo $status_label; ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel">Tambah Pit</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="form-group">
            <label>Pilih Area</label>
            <select name="area_id" class="form-control select2" required style="width: 100%;">
                <option value="">-- Pilih Area --</option>
                <?php foreach($areas as $area): ?>
                    <option value="<?php echo $area['id']; ?>"><?php echo htmlspecialchars($area['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Nama Pit</label>
            <input type="text" name="nama" class="form-control" placeholder="Contoh: Pit A" required>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" class="form-control" placeholder="Deskripsi optional"></textarea>
        </div>
        <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="1">Aktif</option>
                <option value="0">Tidak Aktif</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel">Edit Pit</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>Pilih Area</label>
            <select name="area_id" id="edit_area_id" class="form-control select2" required style="width: 100%;">
                <option value="">-- Pilih Area --</option>
                <?php foreach($areas as $area): ?>
                    <option value="<?php echo $area['id']; ?>"><?php echo htmlspecialchars($area['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Nama Pit</label>
            <input type="text" name="nama" id="edit_nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" id="edit_des" class="form-control"></textarea>
        </div>
        <div class="form-group">
            <label>Status</label>
            <select name="status" id="edit_status" class="form-control">
                <option value="1">Aktif</option>
                <option value="0">Tidak Aktif</option>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    $('#example1').DataTable({
        "ordering": true,
        "language": {
            "search": "Cari:",
            "lengthMenu": "Tampilkan _MENU_ data",
            "info": "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
            "paginate": {
                "first": "Awal",
                "last": "Akhir",
                "next": "Lanjut",
                "previous": "Kembali"
            }
        }
    });

    // Initialize Select2 if available
    if($('.select2').length) {
        $('.select2').select2();
    }

    // Add
    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/PitController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    console.log(res);
                    alert('Error parsing response');
                }
            }
        });
    });

    // Get Data for Edit
    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/PitController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_area_id').val(data.area_id).trigger('change');
                $('#edit_nama').val(data.nama);
                $('#edit_des').val(data.des);
                $('#edit_status').val(data.status);
                $('#editModal').modal('show');
            }
        });
    });

    // Update
    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/PitController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                     alert('Error parsing response');
                }
            }
        });
    });

    $(document).on('click', '.delete-btn', function () {
        if (confirm('Yakin ingin menghapus data ini?')) {
    
            var id = $(this).data('id');
    
            if (!id) {
                alert('ID tidak ditemukan');
                return;
            }
    
            $.ajax({
                url: 'index.php?action=delete',
                type: 'POST',
                dataType: 'json',
                data: { id: id },
                success: function (data) {
                    alert(data.message);
                    if (data.status === 'success') {
                        location.reload();
                    }
                },
                error: function () {
                    alert('Gagal menghubungi server');
                }
            });
        }
    });

});
</script>
