<?php
// view/m_mining_cont/index.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';
?>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Master Data
        <small>Mining Contractor</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Master Data</li>
        <li class="active">Mining Contractor</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Contractor</button>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="5%">No</th>
                      <th>Kode</th>
                      <th>Nama Contractor</th>
                      <th>PIC</th>
                      <th>HP</th>
                      <th>Alamat</th>
                      <th width="12%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT * FROM m_mining_cont ORDER BY id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><span class="label label-info"><?php echo htmlspecialchars($row['codx']); ?></span></td>
                      <td><b><?php echo htmlspecialchars($row['nama']); ?></b>
                        <?php if(!empty($row['des'])): ?>
                        <br><small class="text-muted"><?php echo htmlspecialchars(substr($row['des'], 0, 50)); ?><?php echo strlen($row['des']) > 50 ? '...' : ''; ?></small>
                        <?php endif; ?>
                      </td>
                      <td><?php echo htmlspecialchars($row['pic']); ?></td>
                      <td><?php echo htmlspecialchars($row['hp']); ?></td>
                      <td><?php echo htmlspecialchars(substr($row['alamat'], 0, 40)); ?><?php echo strlen($row['alamat']) > 40 ? '...' : ''; ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel"><i class="fa fa-plus"></i> Tambah Mining Contractor</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Nama Contractor <span class="text-danger">*</span></label>
                    <input type="text" name="nama" class="form-control" placeholder="Nama Mining Contractor" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Kode Contractor</label>
                    <input type="text" name="codx" class="form-control" placeholder="CN: TJA-001">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Person In Charge (PIC)</label>
                    <input type="text" name="pic" class="form-control" placeholder="Nama PIC">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>No. HP / Telepon</label>
                    <input type="text" name="hp" class="form-control" placeholder="08xxxxxxxxxx">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label>Alamat</label>
            <textarea name="alamat" class="form-control" rows="2" placeholder="Alamat lengkap"></textarea>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" class="form-control" rows="3" placeholder="Deskripsi contractor"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel"><i class="fa fa-edit"></i> Edit Mining Contractor</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Nama Contractor <span class="text-danger">*</span></label>
                    <input type="text" name="nama" id="edit_nama" class="form-control" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Kode Contractor</label>
                    <input type="text" name="codx" id="edit_codx" class="form-control">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Person In Charge (PIC)</label>
                    <input type="text" name="pic" id="edit_pic" class="form-control">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>No. HP / Telepon</label>
                    <input type="text" name="hp" id="edit_hp" class="form-control">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label>Alamat</label>
            <textarea name="alamat" id="edit_alamat" class="form-control" rows="2"></textarea>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" id="edit_des" class="form-control" rows="3"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    $('#example1').DataTable({
        "ordering": true
    });

    // Add
    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/MiningContController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    alert('Error parsing response');
                }
            }
        });
    });

    // Get Data for Edit
    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/MiningContController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_nama').val(data.nama);
                $('#edit_des').val(data.des);
                $('#edit_hp').val(data.hp);
                $('#edit_pic').val(data.pic);
                $('#edit_alamat').val(data.alamat);
                $('#edit_codx').val(data.codx);
                $('#editModal').modal('show');
            }
        });
    });

    // Update
    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/MiningContController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                     alert('Error parsing response');
                }
            }
        });
    });

    // Delete
    $('.delete-btn').on('click', function(){
        if(confirm('Yakin ingin menghapus data ini?')){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/MiningContController.php?action=delete',
                method: 'POST',
                data: {id: id},
                success: function(res){
                    try {
                        var data = JSON.parse(res);
                        if(data.status == 'success'){
                            alert(data.message);
                            location.reload();
                        } else {
                            alert(data.message);
                        }
                    } catch(e) {
                         alert('Error parsing response');
                    }
                }
            });
        }
    });
});
</script>
