<?php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

$sqlKat = "SELECT * FROM m_kategori_material ORDER BY id ASC";
$stmtKat = $conn->prepare($sqlKat);
$stmtKat->execute();
$kategoriList = $stmtKat->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Master Data
        <small>Material</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Master Data</li>
        <li class="active">Material</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Material</button>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="5%">No</th>
                      <th width="10%">Kode</th>
                      <th>Nama Material</th>
                      <th>Deskripsi</th>
                      <th>Kategori</th>
                      <th width="15%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT m.*, k.nama as kategori_nama FROM m_material m LEFT JOIN m_kategori_material k ON m.kategori_id = k.id ORDER BY m.id ASC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><span class="badge" style="background-color:#3c8dbc; color:#fff; font-size:13px; padding:5px 10px; font-weight:bold;"><?php echo htmlspecialchars($row['kode']); ?></span></td>
                      <td><b><?php echo htmlspecialchars($row['nama']); ?></b></td>
                      <td><?php echo htmlspecialchars($row['des']); ?></td>
                      <td><span class="label label-primary"><?php echo htmlspecialchars($row['kategori_nama'] ?? '-'); ?></span></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel">Tambah Material</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="form-group">
            <label>Kode Material</label>
            <input type="text" name="kode" class="form-control" placeholder="Contoh: C, OB, IB" required>
        </div>
        <div class="form-group">
            <label>Nama Material</label>
            <input type="text" name="nama" class="form-control" placeholder="Contoh: Batubara" required>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" class="form-control" placeholder="Deskripsi material"></textarea>
        </div>
        <div class="form-group">
            <label>Kategori Material</label>
            <select name="kategori_id" class="form-control" required>
                <option value="">-- Pilih Kategori --</option>
                <?php foreach($kategoriList as $kat): ?>
                <option value="<?php echo $kat['id']; ?>"><?php echo htmlspecialchars($kat['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel">Edit Material</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>Kode Material</label>
            <input type="text" name="kode" id="edit_kode" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Nama Material</label>
            <input type="text" name="nama" id="edit_nama" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Deskripsi</label>
            <textarea name="des" id="edit_des" class="form-control"></textarea>
        </div>
        <div class="form-group">
            <label>Kategori Material</label>
            <select name="kategori_id" id="edit_kategori_id" class="form-control" required>
                <option value="">-- Pilih Kategori --</option>
                <?php foreach($kategoriList as $kat): ?>
                <option value="<?php echo $kat['id']; ?>"><?php echo htmlspecialchars($kat['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    $('#example1').DataTable({
        "ordering": true,
        "language": {
            "search": "Cari:",
            "lengthMenu": "Tampilkan _MENU_ data",
            "info": "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
            "paginate": {
                "first": "Awal",
                "last": "Akhir",
                "next": "Lanjut",
                "previous": "Kembali"
            }
        }
    });

    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/MaterialController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    console.log(res);
                    alert('Error parsing response');
                }
            }
        });
    });

    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/MaterialController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_kode').val(data.kode);
                $('#edit_nama').val(data.nama);
                $('#edit_des').val(data.des);
                $('#edit_kategori_id').val(data.kategori_id);
                $('#editModal').modal('show');
            }
        });
    });

    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/MaterialController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                     alert('Error parsing response');
                }
            }
        });
    });

    $('.delete-btn').on('click', function(){
        if(confirm('Yakin ingin menghapus data ini?')){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/MaterialController.php?action=delete',
                method: 'POST',
                data: {id: id},
                success: function(res){
                    try {
                        var data = JSON.parse(res);
                        if(data.status == 'success'){
                            alert(data.message);
                            location.reload();
                        } else {
                            alert(data.message);
                        }
                    } catch(e) {
                         alert('Error parsing response');
                    }
                }
            });
        }
    });
});
</script>
