<?php
include '../../config.php';
session_start();

if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
    exit;
}

/* =========================
   AJAX HANDLER (PRODUCTION)
========================= */
if (
    isset($_GET['action']) &&
    in_array($_GET['action'], ['create','get','update','delete'])
) {
    header('Content-Type: application/json');

    try {

        /* CREATE */
        if ($_GET['action'] === 'create') {
            $stmt = $conn->prepare("
                INSERT INTO m_lhl
                (kode_lhl,tanggal,no_unit,shift,no_surat_timbangan,bruto,tara,netto,driver,bbm)
                VALUES (?,?,?,?,?,?,?,?,?,?)
            ");
            $stmt->execute([
                $_POST['kode_lhl'],
                $_POST['tanggal'],
                $_POST['no_unit'],
                $_POST['shift'],
                $_POST['no_surat_timbangan'],
                $_POST['bruto'],
                $_POST['tara'],
                $_POST['netto'],
                $_POST['driver'],
                $_POST['bbm']
            ]);

            echo json_encode(['status'=>'success','message'=>'Data berhasil ditambahkan']);
            exit;
        }

        /* GET */
        if ($_GET['action'] === 'get') {
            $stmt = $conn->prepare("SELECT * FROM m_lhl WHERE id=?");
            $stmt->execute([$_GET['id']]);
            echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
            exit;
        }

        /* UPDATE */
        if ($_GET['action'] === 'update') {
            $stmt = $conn->prepare("
                UPDATE m_lhl SET
                kode_lhl=?, tanggal=?, no_unit=?, shift=?, no_surat_timbangan=?,
                bruto=?, tara=?, netto=?, driver=?, bbm=?
                WHERE id=?
            ");
            $stmt->execute([
                $_POST['kode_lhl'],
                $_POST['tanggal'],
                $_POST['no_unit'],
                $_POST['shift'],
                $_POST['no_surat_timbangan'],
                $_POST['bruto'],
                $_POST['tara'],
                $_POST['netto'],
                $_POST['driver'],
                $_POST['bbm'],
                $_POST['id']
            ]);

            echo json_encode(['status'=>'success','message'=>'Data berhasil diupdate']);
            exit;
        }

        /* DELETE */
        if ($_GET['action'] === 'delete') {

         
            $id = $_POST['id'];
            try {
                $sql = "DELETE FROM m_lhl WHERE id = :id";
                $stmt = $conn->prepare($sql);
                $stmt->execute([':id' => $id]);
                echo json_encode(['status' => 'success', 'message' => 'Data Pit berhasil dihapus']);
            } catch(PDOException $e) {
                echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
            }
      
        }
        
        

    } catch (Exception $e) {
        echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
        exit;
    }
}

include '../header.php';
include '../sidebar.php';
?>

<div class="content-wrapper">
  <section class="content-header">
    <h1>Laporan Harian Lapangan <small>(LHL)</small></h1>
  </section>

  <section class="content">
    <div class="box box-primary">
      <div class="box-header">
        <button class="btn btn-primary" data-toggle="modal" data-target="#modalForm">
          <i class="fa fa-plus"></i> Tambah LHL
        </button>
      </div>

      <div class="box-body table-responsive">
        <table id="lhlTable" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>No</th>
              <th>Kode</th>
              <th>Tanggal</th>
              <th>Unit</th>
              <th>Shift</th>
              <th>No Timbangan</th>
              <th>Netto (Kg)</th>
              <th>Driver</th>
              <th>BBM</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
        <?php
        $no=1;
        $stmt = $conn->query("SELECT * FROM m_lhl");
        while($r=$stmt->fetch(PDO::FETCH_ASSOC)){
        ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><span class="badge bg-blue"><?= htmlspecialchars($r['kode_lhl']) ?></span></td>
            <td><?= $r['tanggal'] ?></td>
            <td><?= htmlspecialchars($r['no_unit']) ?></td>
            <td>Shift <?= $r['shift'] ?></td>
            <td><?= htmlspecialchars($r['no_surat_timbangan']) ?></td>
            <td><b><?= number_format($r['netto']) ?></b></td>
            <td><?= htmlspecialchars($r['driver']) ?></td>
            <td><?= $r['bbm'] ?></td>
            <td>
            <button class="btn btn-warning btn-xs edit" data-id="<?= $r['id'] ?>"><i class="fa fa-edit"></i></button>
            <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $r['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
            </td>
        </tr>
        <?php } ?>
        </tbody>
        </table>
        </div>
        </div>
        </section>
        </div>
        
        
        <style>
            /* ======================
   FORM INPUT – BORDER HITAM
====================== */
.modal .form-control {
  border: 2px solid #000 !important;
  color: #000 !important;
}

/* Focus tetap rapi tapi hitam */
.modal .form-control:focus {
  border-color: #000 !important;
  box-shadow: 0 0 0 2px rgba(0,0,0,0.15) !important;
}

        </style>

        <!-- MODAL -->
        <div class="modal fade" id="modalForm">
            <div class="modal-dialog">
                <div class="modal-content">
                <form id="lhlForm">
                <input type="hidden" name="id" id="id">
                
                <div class="modal-header">
                <h4 class="modal-title">Form LHL</h4>
                </div>
                
                <div class="modal-body">
                    <input class="form-control" name="kode_lhl" id="kode_lhl" placeholder="Kode LHL" required><br>
                    <input type="date" class="form-control" name="tanggal" id="tanggal" required><br>
                    <input class="form-control" name="no_unit" id="no_unit" placeholder="No Unit" required><br>
                    
                    <select class="form-control" name="shift" id="shift" required>
                    <option value="">Pilih Shift</option>
                    <option value="1">Shift 1</option>
                    <option value="2">Shift 2</option>
                    <option value="3">Shift 3</option>
                    </select><br>
                    
                    <input class="form-control" name="no_surat_timbangan" id="no_surat_timbangan" placeholder="No Timbangan" required><br>
                    <input type="number" class="form-control" name="bruto" id="bruto" placeholder="Bruto" required><br>
                    <input type="number" class="form-control" name="tara" id="tara" placeholder="Tara" required><br>
                    <input type="number" class="form-control" name="netto" id="netto" readonly><br>
                    <input class="form-control" name="driver" id="driver" placeholder="Driver" required><br>
                    <input type="number" step="0.01" class="form-control" name="bbm" id="bbm" placeholder="BBM (Liter)" required>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                    <button class="btn btn-primary">Simpan</button>
                </div>
                </form>
                </div>
            </div>
        </div>

<?php include '../footer.php'; ?>

<script>
$(function(){

    $('#lhlTable').DataTable();

    $('#bruto,#tara').on('input', function(){
        var bruto = parseFloat($('#bruto').val()) || 0;
        var tara  = parseFloat($('#tara').val()) || 0;
        $('#netto').val(bruto - tara);
    });

    $('#lhlForm').submit(function(e){
        e.preventDefault();

        var act = $('#id').val() ? 'update' : 'create';

        $.post('?action=' + act, $(this).serialize(), function(res){
            alert(res.message);
            if(res.status === 'success'){
                location.reload();
            }
        }, 'json');
    });

    $('.edit').click(function(){
        var id = $(this).data('id');

        $.get('?action=get&id=' + id, function(d){

            $('#id').val(d.id);
            $('#kode_lhl').val(d.kode_lhl);
            $('#tanggal').val(d.tanggal);
            $('#no_unit').val(d.no_unit);
            $('#shift').val(d.shift);
            $('#no_surat_timbangan').val(d.no_surat_timbangan);
            $('#bruto').val(d.bruto);
            $('#tara').val(d.tara);
            $('#netto').val(d.netto);
            $('#driver').val(d.driver);
            $('#bbm').val(d.bbm);

            $('#modalForm').modal('show');

        }, 'json');
    });

    // Delete
    $(document).on('click', '.delete-btn', function () {
    if (confirm('Yakin ingin menghapus data ini?')) {

        var id = $(this).data('id');

        $.ajax({
            url: 'index.php?action=delete',
            type: 'POST',
            data: { id: id },
            success: function (res) {
                let data;

                try {
                    data = (typeof res === 'object') ? res : JSON.parse(res);
                } catch (e) {
                    console.log(res);
                    location.reload(); // 🔥 tetap reload
                    return;
                }

                alert(data.message);
                if (data.status === 'success') {
                    location.reload();
                }
            },
            error: function (xhr) {
                console.log(xhr.responseText);
                location.reload(); // 🔥 FORCE reload
            }
        });
    }
});





});
</script>

