<?php
// view/m_heq/index.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Fetch Type Units for Dropdown
$sql_type = "SELECT * FROM m_type_unit ORDER BY nama ASC";
$stmt_type = $conn->prepare($sql_type);
$stmt_type->execute();
$types = $stmt_type->fetchAll(PDO::FETCH_ASSOC);

// Fetch Mining Contractors for Dropdown
$sql_cont = "SELECT * FROM m_mining_cont ORDER BY nama ASC";
$stmt_cont = $conn->prepare($sql_cont);
$stmt_cont->execute();
$contractors = $stmt_cont->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Custom Select2 Styles for Dark Theme -->
<style>
/* Select2 Container */
.select2-container--default .select2-selection--single {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
    border-radius: 4px !important;
    height: 38px !important;
    padding: 4px 8px !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff !important;
    line-height: 28px !important;
    padding-left: 0 !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #888 transparent transparent transparent !important;
}

.select2-container--default .select2-selection--single .select2-selection__placeholder {
    color: #888 !important;
}

.select2-container--default .select2-selection--single .select2-selection__clear {
    color: #888 !important;
    font-size: 18px !important;
    margin-right: 10px !important;
}

.select2-container--default .select2-selection--single .select2-selection__clear:hover {
    color: #ff9900 !important;
}

/* Dropdown */
.select2-container--default .select2-dropdown {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
    border-radius: 4px !important;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.5) !important;
}

/* Search Box */
.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: #1e1e1e !important;
    border: 1px solid #555 !important;
    border-radius: 4px !important;
    color: #fff !important;
    padding: 8px 12px !important;
}

.select2-container--default .select2-search--dropdown .select2-search__field:focus {
    border-color: #ff9900 !important;
    outline: none !important;
}

/* Results */
.select2-container--default .select2-results__option {
    padding: 10px 12px !important;
    color: #ccc !important;
    background-color: #2c2c2c !important;
    transition: background-color 0.15s ease !important;
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #3a3a3a !important;
    color: #ff9900 !important;
}

.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: #ff9900 !important;
    color: #000 !important;
}

.select2-container--default .select2-results__option:hover {
    background-color: #3a3a3a !important;
    color: #fff !important;
}

/* No Results */
.select2-container--default .select2-results__message {
    color: #888 !important;
}

/* Focus state */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #ff9900 !important;
    box-shadow: 0 0 0 2px rgba(255, 153, 0, 0.15) !important;
}

/* Open state */
.select2-container--default.select2-container--open .select2-selection--single {
    border-color: #ff9900 !important;
}

/* Responsive */
@media (max-width: 768px) {
    .select2-container {
        width: 100% !important;
    }
    .select2-container--default .select2-selection--single {
        height: 42px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 32px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 40px !important;
    }
}

/* Hide default tooltip/title */
.select2-selection__rendered[title] {
    pointer-events: auto;
}
.select2-selection__rendered::after {
    display: none !important;
}

/* Remove native tooltip */
.select2-container--default .select2-selection--single .select2-selection__rendered {
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}

/* Hide any tooltip elements */
.select2-hidden-accessible {
    border: 0 !important;
    clip: rect(0 0 0 0) !important;
    height: 1px !important;
    margin: -1px !important;
    overflow: hidden !important;
    padding: 0 !important;
    position: absolute !important;
    width: 1px !important;
}

/* IMPORTANT: Fix Select2 dropdown inside Bootstrap modal */
.modal-open .select2-container--open {
    z-index: 10060 !important;
}

.modal-open .select2-dropdown {
    z-index: 10060 !important;
}

/* Ensure dropdown appears below the field, not above */
.select2-container--open .select2-dropdown--below {
    margin-top: 2px;
}

.select2-container--open .select2-dropdown--above {
    margin-bottom: 2px;
}

/* Fix modal-body for proper Select2 positioning */
.modal .modal-body {
    position: relative;
    overflow: visible;
}

.modal .modal-content {
    overflow: visible;
}

.modal .modal-dialog {
    overflow: visible;
}

/* Form group positioning */
.modal .form-group {
    position: relative;
}

/* Ensure Select2 container is properly positioned */
.modal .select2-container {
    position: relative;
    display: block;
}

/* Fix dropdown attachment */
.select2-container--open .select2-dropdown {
    position: absolute;
    left: 0;
    width: 100%;
}
</style>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Master Data
        <small>Heavy Equipment</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Master Data</li>
        <li class="active">Heavy Equipment</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-xs-12">
            
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Unit HEQ</button>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="5%">No</th>
                      <th>No Unit</th>
                      <th>Nama Unit</th>
                      <th>Mining Contractor</th>
                      <th>Type Unit</th>
                      <th>Brand / Model</th>
                      <th width="12%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT h.*, t.nama as type_nama, mc.nama as contractor_nama 
                            FROM m_heq h 
                            LEFT JOIN m_type_unit t ON h.type_id = t.id 
                            LEFT JOIN m_mining_cont mc ON h.mining_cont_id = mc.id
                            ORDER BY h.id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><b><?php echo htmlspecialchars($row['no_unit']); ?></b></td>
                      <td><?php echo htmlspecialchars($row['nama_unit'] ?? ''); ?></td>
                      <td>
                        <?php if(!empty($row['contractor_nama'])): ?>
                          <span class="label label-warning"><?php echo htmlspecialchars($row['contractor_nama']); ?></span>
                        <?php else: ?>
                          <span class="text-muted">-</span>
                        <?php endif; ?>
                      </td>
                      <td><span class="label label-info"><?php echo htmlspecialchars($row['type_nama']); ?></span></td>
                      <td><?php echo htmlspecialchars($row['brand_model']); ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i> Edit</button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i> Hapus</button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>

        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="addModalLabel">Tambah Heavy Equipment</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="form-group">
            <label>No Unit <span class="text-danger">*</span></label>
            <input type="text" name="no_unit" class="form-control" placeholder="CN: DT-01" required>
        </div>
        <div class="form-group">
            <label>Nama Unit <span class="text-danger">*</span></label>
            <input type="text" name="nama_unit" class="form-control" placeholder="Masukkan nama unit" required>
        </div>
        <div class="form-group">
            <label>Mining Contractor</label>
            <select name="mining_cont_id" id="add_mining_cont_id" class="form-control" style="width: 100%;">
                <option value="">-- Pilih Contractor --</option>
                <?php foreach($contractors as $c): ?>
                    <option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Type Unit <span class="text-danger">*</span></label>
            <select name="type_id" id="add_type_id" class="form-control" style="width: 100%;" required>
                <option value="">-- Pilih Type --</option>
                <?php foreach($types as $t): ?>
                    <option value="<?php echo $t['id']; ?>"><?php echo htmlspecialchars($t['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Brand / Model</label>
            <input type="text" name="brand_model" class="form-control" placeholder="CN: Komatsu PC200">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="editModalLabel">Edit Heavy Equipment</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>No Unit <span class="text-danger">*</span></label>
            <input type="text" name="no_unit" id="edit_no_unit" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Nama Unit <span class="text-danger">*</span></label>
            <input type="text" name="nama_unit" id="edit_nama_unit" class="form-control" placeholder="Masukkan nama unit" required>
        </div>
        <div class="form-group">
            <label>Mining Contractor</label>
            <select name="mining_cont_id" id="edit_mining_cont_id" class="form-control" style="width: 100%;">
                <option value="">-- Pilih Contractor --</option>
                <?php foreach($contractors as $c): ?>
                    <option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Type Unit <span class="text-danger">*</span></label>
            <select name="type_id" id="edit_type_id" class="form-control" style="width: 100%;" required>
                <option value="">-- Pilih Type --</option>
                <?php foreach($types as $t): ?>
                    <option value="<?php echo $t['id']; ?>"><?php echo htmlspecialchars($t['nama']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Brand / Model</label>
            <input type="text" name="brand_model" id="edit_brand_model" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>
<script>
$(document).ready(function() {
    // Select2 Configuration Options
    var select2Config = {
        allowClear: true,
        minimumResultsForSearch: 0, // Always show search box
        selectOnClose: false, // Prevent auto-select when closing
        closeOnSelect: true,
        width: '100%'
    };

    // Initialize Select2 for Add Modal
    $('#add_mining_cont_id').select2($.extend({}, select2Config, {
        dropdownParent: $('#addModal .modal-body'),
        placeholder: '-- Pilih Contractor --'
    }));
    $('#add_type_id').select2($.extend({}, select2Config, {
        dropdownParent: $('#addModal .modal-body'),
        placeholder: '-- Pilih Type --'
    }));

    // Initialize Select2 for Edit Modal
    $('#edit_mining_cont_id').select2($.extend({}, select2Config, {
        dropdownParent: $('#editModal .modal-body'),
        placeholder: '-- Pilih Contractor --'
    }));
    $('#edit_type_id').select2($.extend({}, select2Config, {
        dropdownParent: $('#editModal .modal-body'),
        placeholder: '-- Pilih Type --'
    }));

    // Remove title attribute to prevent native tooltip
    function removeSelect2Titles() {
        $('.select2-selection__rendered').removeAttr('title');
    }
    
    // Remove titles on select2 events
    $('#add_mining_cont_id, #add_type_id, #edit_mining_cont_id, #edit_type_id').on('select2:select select2:close change', function() {
        setTimeout(removeSelect2Titles, 10);
    });
    
    // Initial removal
    removeSelect2Titles();
    
    // Also remove on modal show and fix Select2 positioning
    $('#addModal').on('shown.bs.modal', function() {
        setTimeout(function() {
            removeSelect2Titles();
            // Destroy and reinitialize Select2 for Add Modal to fix positioning
            $('#add_mining_cont_id').select2('destroy').select2($.extend({}, select2Config, {
                dropdownParent: $('#addModal .modal-body'),
                placeholder: '-- Pilih Contractor --'
            }));
            $('#add_type_id').select2('destroy').select2($.extend({}, select2Config, {
                dropdownParent: $('#addModal .modal-body'),
                placeholder: '-- Pilih Type --'
            }));
        }, 100);
    });
    
    $('#editModal').on('shown.bs.modal', function() {
        setTimeout(removeSelect2Titles, 100);
    });

    // Reset Add Modal when closed
    $('#addModal').on('hidden.bs.modal', function() {
        $('#addForm')[0].reset();
        $('#add_mining_cont_id').val('').trigger('change');
        $('#add_type_id').val('').trigger('change');
    });

    $('#example1').DataTable({
        "ordering": true
    });

    // Add
    $('#addForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/HeavyEquipmentController.php?action=create',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                    alert('Error parsing response');
                }
            }
        });
    });

    // Get Data for Edit
    $('.edit-btn').on('click', function(){
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/HeavyEquipmentController.php?action=get',
            method: 'GET',
            data: {id: id},
            dataType: 'json',
            success: function(data){
                $('#edit_id').val(data.id);
                $('#edit_no_unit').val(data.no_unit);
                $('#edit_nama_unit').val(data.nama_unit || '');
                $('#edit_mining_cont_id').val(data.mining_cont_id).trigger('change');
                $('#edit_type_id').val(data.type_id).trigger('change');
                $('#edit_brand_model').val(data.brand_model);
                $('#editModal').modal('show');
            }
        });
    });

    // Update
    $('#editForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: '../../controller/HeavyEquipmentController.php?action=update',
            method: 'POST',
            data: $(this).serialize(),
            success: function(res){
                try {
                    var data = JSON.parse(res);
                    if(data.status == 'success'){
                        alert(data.message);
                        location.reload();
                    } else {
                        alert(data.message);
                    }
                } catch(e) {
                     alert('Error parsing response');
                }
            }
        });
    });

    // Delete
    $('.delete-btn').on('click', function(){
        if(confirm('Yakin ingin menghapus data ini?')){
            var id = $(this).data('id');
            $.ajax({
                url: '../../controller/HeavyEquipmentController.php?action=delete',
                method: 'POST',
                data: {id: id},
                success: function(res){
                    try {
                        var data = JSON.parse(res);
                        if(data.status == 'success'){
                            alert(data.message);
                            location.reload();
                        } else {
                            alert(data.message);
                        }
                    } catch(e) {
                         alert('Error parsing response');
                    }
                }
            });
        }
    });
});
</script>
