<?php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Get type units for category dropdown
$sqlTypeUnits = "SELECT * FROM m_type_unit ORDER BY nama ASC";
$stmtTypeUnits = $conn->prepare($sqlTypeUnits);
$stmtTypeUnits->execute();
$typeUnitList = $stmtTypeUnits->fetchAll(PDO::FETCH_ASSOC);

// Get all HEQ for reference
$sqlHeq = "SELECT h.*, t.nama as type_nama FROM m_heq h 
           LEFT JOIN m_type_unit t ON h.type_id = t.id 
           ORDER BY t.nama ASC, h.nama_unit ASC";
$stmtHeq = $conn->prepare($sqlHeq);
$stmtHeq->execute();
$heqList = $stmtHeq->fetchAll(PDO::FETCH_ASSOC);

// Get all drivers and operators
$sqlUsers = "SELECT id, nama, level_id, 
             CASE WHEN level_id = 3 THEN 'Driver' ELSE 'Operator' END as role 
             FROM m_user 
             WHERE level_id IN (3, 4) AND status_aktif = 1 
             ORDER BY level_id ASC, nama ASC";
$stmtUsers = $conn->prepare($sqlUsers);
$stmtUsers->execute();
$userList = $stmtUsers->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
.info-box-number { font-size: 24px; }

/* DataTables Pagination - Clean Style */
.dataTables_wrapper .dataTables_paginate {
    padding: 15px 0;
    float: right;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    display: inline-block;
    padding: 6px 12px;
    margin: 0 2px;
    border-radius: 4px;
    background: #333;
    border: 1px solid #555;
    color: #fff !important;
    cursor: pointer;
    font-size: 14px;
    text-decoration: none;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: #ff9900;
    border-color: #ff9900;
    color: #000 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: #ff9900 !important;
    border-color: #ff9900 !important;
    color: #000 !important;
    font-weight: 600;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover {
    background: #222 !important;
    border-color: #333 !important;
    color: #555 !important;
    cursor: default;
}

/* DataTables Length & Search */
.dataTables_wrapper .dataTables_length {
    float: left;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length label {
    color: #ccc;
}

.dataTables_wrapper .dataTables_length select {
    padding: 5px 10px;
    border-radius: 4px;
    margin: 0 5px;
    min-width: 60px;
}

.dataTables_wrapper .dataTables_filter {
    float: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    padding: 6px 15px;
    border-radius: 15px;
    border: 1px solid #555;
    margin-left: 8px;
    min-width: 200px;
}

/* DataTables Info */
.dataTables_wrapper .dataTables_info {
    float: left;
    padding: 15px 0;
    color: #aaa;
    font-size: 13px;
}

/* Clear float */
.dataTables_wrapper::after {
    content: "";
    display: table;
    clear: both;
}

/* Filter Section */
.filter-section {
    display: flex;
    gap: 10px;
    align-items: center;
    flex-wrap: wrap;
}

.filter-group {
    display: flex;
    align-items: center;
    gap: 5px;
}

.filter-label {
    color: #ff9900 !important;
    font-size: 12px;
    font-weight: 600;
    margin: 0 !important;
    white-space: nowrap;
}

.filter-input {
    width: 150px !important;
    padding: 6px 10px !important;
    border-radius: 6px !important;
    font-size: 13px !important;
}

.filter-input::-webkit-calendar-picker-indicator {
    filter: invert(1);
    cursor: pointer;
}

/* Table Improvements */
.table > tbody > tr > td {
    vertical-align: middle !important;
}

/* Select2 Dark Theme */
.select2-container--default .select2-selection--single {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
    height: 38px !important;
    padding: 4px 8px !important;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff !important;
    line-height: 28px !important;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
}
.select2-container--default .select2-dropdown {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
}
.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: #1e1e1e !important;
    border: 1px solid #555 !important;
    color: #fff !important;
}
.select2-container--default .select2-results__option {
    color: #ccc !important;
    background-color: #2c2c2c !important;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #3a3a3a !important;
    color: #ff9900 !important;
}
.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: #ff9900 !important;
    color: #000 !important;
}
.modal-open .select2-container--open { z-index: 10060 !important; }
.modal-open .select2-dropdown { z-index: 10060 !important; }
.modal .modal-body { overflow: visible; }
.modal .modal-content { overflow: visible; }

/* Responsive Filter */
@media (max-width: 992px) {
    .filter-section {
        width: 100%;
        margin-top: 10px;
        justify-content: flex-start;
    }
    
    .filter-group {
        margin-bottom: 5px;
    }
    
    .filter-input {
        width: 130px !important;
    }
}

@media (max-width: 576px) {
    .filter-section {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .filter-group {
        width: 100%;
    }
    
    .filter-input {
        width: 100% !important;
        flex: 1;
    }
    
    #applyFilter, #resetFilter {
        width: 48%;
    }
}
</style>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Fuel Management
        <small>Fueling (Pengisian Fuel)</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Fuel Management</li>
        <li class="active">Fueling</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-aqua">
            <span class="info-box-icon"><i class="fa fa-fire"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Pengisian Hari Ini</span>
              <span class="info-box-number">
                <?php 
                $today = date('Y-m-d');
                $sqlCount = "SELECT COUNT(*) FROM m_fueling WHERE tanggal = :today";
                $stmtCount = $conn->prepare($sqlCount);
                $stmtCount->execute([':today' => $today]);
                echo $stmtCount->fetchColumn();
                ?>
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-green">
            <span class="info-box-icon"><i class="fa fa-tint"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Liter Hari Ini</span>
              <span class="info-box-number">
                <?php 
                $sqlLiter = "SELECT COALESCE(SUM(jumlah_liter),0) FROM m_fueling WHERE tanggal = :today";
                $stmtLiter = $conn->prepare($sqlLiter);
                $stmtLiter->execute([':today' => $today]);
                echo number_format($stmtLiter->fetchColumn(), 2);
                ?> L
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-yellow">
            <span class="info-box-icon"><i class="fa fa-calendar"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Pengisian Bulan Ini</span>
              <span class="info-box-number">
                <?php 
                $month = date('Y-m');
                $sqlMonth = "SELECT COUNT(*) FROM m_fueling WHERE tanggal LIKE :month";
                $stmtMonth = $conn->prepare($sqlMonth);
                $stmtMonth->execute([':month' => $month . '%']);
                echo $stmtMonth->fetchColumn();
                ?>
              </span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-red">
            <span class="info-box-icon"><i class="fa fa-line-chart"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Liter Bulan Ini</span>
              <span class="info-box-number">
                <?php 
                $sqlLiterMonth = "SELECT COALESCE(SUM(jumlah_liter),0) FROM m_fueling WHERE tanggal LIKE :month";
                $stmtLiterMonth = $conn->prepare($sqlLiterMonth);
                $stmtLiterMonth->execute([':month' => $month . '%']);
                echo number_format($stmtLiterMonth->fetchColumn(), 2);
                ?> L
              </span>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Tambah Fueling</button>
                    
                    <!-- Filter Section -->
                    <div class="pull-right filter-section">
                        <div class="filter-group">
                            <label class="filter-label"><i class="fa fa-calendar"></i> Dari:</label>
                            <input type="date" id="filterTanggalDari" class="form-control filter-input" title="Tanggal Mulai">
                        </div>
                        <div class="filter-group">
                            <label class="filter-label">Sampai:</label>
                            <input type="date" id="filterTanggalSampai" class="form-control filter-input" title="Tanggal Akhir">
                        </div>
                        <button type="button" id="applyFilter" class="btn btn-warning" title="Terapkan Filter">
                            <i class="fa fa-filter"></i> Filter
                        </button>
                        <button type="button" id="resetFilter" class="btn btn-default" title="Reset Filter">
                            <i class="fa fa-refresh"></i> Reset
                        </button>
                    </div>
                </div>
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="3%">No</th>
                      <th>Tanggal</th>
                      <th>Unit</th>
                      <th>Type</th>
                      <th>Driver/Operator</th>
                      <th>Jumlah Liter</th>
                      <th>HM Awal</th>
                      <th>HM Akhir</th>
                      <th>Keterangan</th>
                      <th width="10%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT f.*, 
                            COALESCE(h.nama_unit, h.no_unit) as unit_nama,
                            t.nama as type_nama,
                            u.nama as user_nama,
                            CASE WHEN u.level_id = 3 THEN 'Driver' WHEN u.level_id = 4 THEN 'Operator' ELSE '-' END as user_role
                            FROM m_fueling f 
                            LEFT JOIN m_heq h ON f.heq_id = h.id 
                            LEFT JOIN m_type_unit t ON h.type_id = t.id
                            LEFT JOIN m_user u ON f.operator_driver_id = u.id 
                            ORDER BY f.id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <tr data-date="<?php echo $row['tanggal']; ?>">
                      <td><?php echo $no++; ?></td>
                      <td data-order="<?php echo $row['tanggal']; ?>"><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                      <td><b><?php echo htmlspecialchars($row['unit_nama'] ?? '-'); ?></b></td>
                      <td><span class="badge" style="background-color:#3c8dbc;"><?php echo htmlspecialchars($row['type_nama'] ?? '-'); ?></span></td>
                      <td><?php echo htmlspecialchars($row['user_nama'] ?? '-'); ?> <small class="text-muted">(<?php echo $row['user_role']; ?>)</small></td>
                      <td><b><?php echo number_format($row['jumlah_liter'], 2); ?></b> L</td>
                      <td><?php echo $row['hm_awal'] ? number_format($row['hm_awal'], 2) : '-'; ?></td>
                      <td><?php echo $row['hm_akhir'] ? number_format($row['hm_akhir'], 2) : '-'; ?></td>
                      <td><?php echo htmlspecialchars($row['keterangan'] ?? '-'); ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i></button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i></button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>
        </div>
      </div>
    </section>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Tambah Fueling</h4>
      </div>
      <form id="addForm">
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Tanggal <span class="text-danger">*</span></label>
                <input type="date" name="tanggal" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Jumlah Liter <span class="text-danger">*</span></label>
                <input type="number" name="jumlah_liter" class="form-control" value="0" min="0" step="0.01" required>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Kategori Unit <span class="text-danger">*</span></label>
                <select name="type_id" id="add_type_id" class="form-control select2-fuel" style="width:100%;" required>
                    <option value="">-- Pilih Kategori Unit --</option>
                    <?php foreach($typeUnitList as $type): ?>
                    <option value="<?php echo $type['id']; ?>"><?php echo htmlspecialchars($type['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Unit <span class="text-danger">*</span></label>
                <select name="heq_id" id="add_heq_id" class="form-control select2-fuel" style="width:100%;" required>
                    <option value="">-- Pilih Unit --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>Driver / Operator</label>
                <select name="operator_driver_id" id="add_operator_driver_id" class="form-control select2-fuel" style="width:100%;">
                    <option value="">-- Pilih Driver / Operator --</option>
                    <?php foreach($userList as $user): ?>
                    <option value="<?php echo $user['id']; ?>">[<?php echo $user['role']; ?>] <?php echo htmlspecialchars($user['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Hour Meter Awal</label>
                <input type="number" name="hm_awal" class="form-control" min="0" step="0.01" placeholder="HM Awal">
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Hour Meter Akhir</label>
                <input type="number" name="hm_akhir" class="form-control" min="0" step="0.01" placeholder="HM Akhir">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>Keterangan</label>
                <textarea name="keterangan" class="form-control" rows="2" placeholder="Keterangan tambahan..."></textarea>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Edit Fueling</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Tanggal <span class="text-danger">*</span></label>
                <input type="date" name="tanggal" id="edit_tanggal" class="form-control" required>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Jumlah Liter <span class="text-danger">*</span></label>
                <input type="number" name="jumlah_liter" id="edit_jumlah_liter" class="form-control" min="0" step="0.01" required>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Kategori Unit <span class="text-danger">*</span></label>
                <select name="type_id" id="edit_type_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Kategori Unit --</option>
                    <?php foreach($typeUnitList as $type): ?>
                    <option value="<?php echo $type['id']; ?>"><?php echo htmlspecialchars($type['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Unit <span class="text-danger">*</span></label>
                <select name="heq_id" id="edit_heq_id" class="form-control select2-edit" style="width:100%;" required>
                    <option value="">-- Pilih Unit --</option>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>Driver / Operator</label>
                <select name="operator_driver_id" id="edit_operator_driver_id" class="form-control select2-edit" style="width:100%;">
                    <option value="">-- Pilih Driver / Operator --</option>
                    <?php foreach($userList as $user): ?>
                    <option value="<?php echo $user['id']; ?>">[<?php echo $user['role']; ?>] <?php echo htmlspecialchars($user['nama']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                <label>Hour Meter Awal</label>
                <input type="number" name="hm_awal" id="edit_hm_awal" class="form-control" min="0" step="0.01" placeholder="HM Awal">
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <label>Hour Meter Akhir</label>
                <input type="number" name="hm_akhir" id="edit_hm_akhir" class="form-control" min="0" step="0.01" placeholder="HM Akhir">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
                <label>Keterangan</label>
                <textarea name="keterangan" id="edit_keterangan" class="form-control" rows="2" placeholder="Keterangan tambahan..."></textarea>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>

<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#example1').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "order": [[0, 'asc']]
    });

    // Initialize Select2 for Add Modal
    $('#addModal').on('shown.bs.modal', function () {
        $('.select2-fuel').select2({
            dropdownParent: $('#addModal')
        });
    });

    // Initialize Select2 for Edit Modal
    $('#editModal').on('shown.bs.modal', function () {
        $('.select2-edit').select2({
            dropdownParent: $('#editModal')
        });
    });

    // Cascading dropdown: Type -> HEQ (Add Modal)
    $('#add_type_id').on('change', function() {
        var typeId = $(this).val();
        var heqSelect = $('#add_heq_id');
        heqSelect.html('<option value="">-- Pilih Unit --</option>');
        
        if(typeId) {
            $.ajax({
                url: '../../controller/FuelingController.php?action=get_heq_by_type&type_id=' + typeId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $.each(data, function(i, item) {
                        var label = item.nama_unit ? item.no_unit + ' - ' + item.nama_unit : item.no_unit;
                        heqSelect.append('<option value="' + item.id + '">' + label + '</option>');
                    });
                    heqSelect.trigger('change');
                }
            });
        }
    });

    // Cascading dropdown: Type -> HEQ (Edit Modal)
    $('#edit_type_id').on('change', function() {
        var typeId = $(this).val();
        var heqSelect = $('#edit_heq_id');
        var currentHeqId = heqSelect.data('current');
        heqSelect.html('<option value="">-- Pilih Unit --</option>');
        
        if(typeId) {
            $.ajax({
                url: '../../controller/FuelingController.php?action=get_heq_by_type&type_id=' + typeId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $.each(data, function(i, item) {
                        var label = item.nama_unit ? item.no_unit + ' - ' + item.nama_unit : item.no_unit;
                        var selected = (item.id == currentHeqId) ? 'selected' : '';
                        heqSelect.append('<option value="' + item.id + '" ' + selected + '>' + label + '</option>');
                    });
                    heqSelect.trigger('change');
                }
            });
        }
    });

    // Add Form Submit
    $('#addForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/FuelingController.php?action=create',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Edit Button Click
    $('.edit-btn').on('click', function() {
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/FuelingController.php?action=get&id=' + id,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#edit_id').val(data.id);
                $('#edit_tanggal').val(data.tanggal);
                $('#edit_jumlah_liter').val(data.jumlah_liter);
                $('#edit_hm_awal').val(data.hm_awal);
                $('#edit_hm_akhir').val(data.hm_akhir);
                $('#edit_keterangan').val(data.keterangan);
                $('#edit_operator_driver_id').val(data.operator_driver_id);
                
                // Store current heq_id to select after loading
                $('#edit_heq_id').data('current', data.heq_id);
                
                // Need to get the type_id from heq
                $.ajax({
                    url: '../../controller/FuelingController.php?action=get_heq_by_type&type_id=all',
                    type: 'GET',
                    dataType: 'json',
                    success: function(heqData) {
                        // Find the type_id for the current heq
                        var typeId = null;
                        <?php foreach($heqList as $heq): ?>
                        if(<?php echo $heq['id']; ?> == data.heq_id) {
                            typeId = <?php echo $heq['type_id']; ?>;
                        }
                        <?php endforeach; ?>
                        
                        if(typeId) {
                            $('#edit_type_id').val(typeId).trigger('change');
                        }
                    }
                });
                
                $('#editModal').modal('show');
            }
        });
    });

    // Edit Form Submit
    $('#editForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/FuelingController.php?action=update',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Delete Button Click
    $('.delete-btn').on('click', function() {
        if(!confirm('Yakin ingin menghapus data ini?')) return;
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/FuelingController.php?action=delete',
            type: 'POST',
            data: {id: id},
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Date Filter
    $('#applyFilter').on('click', function() {
        var dari = $('#filterTanggalDari').val();
        var sampai = $('#filterTanggalSampai').val();
        
        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            var rowDate = $(table.row(dataIndex).node()).data('date');
            if(!dari && !sampai) return true;
            if(dari && !sampai) return rowDate >= dari;
            if(!dari && sampai) return rowDate <= sampai;
            return rowDate >= dari && rowDate <= sampai;
        });
        
        table.draw();
        $.fn.dataTable.ext.search.pop();
    });

    $('#resetFilter').on('click', function() {
        $('#filterTanggalDari').val('');
        $('#filterTanggalSampai').val('');
        $.fn.dataTable.ext.search.pop();
        table.draw();
    });
});
</script>
