<?php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Calculate stock summary
$sqlMasuk = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fuel_stock WHERE jenis = 'Masuk'";
$stmtMasuk = $conn->prepare($sqlMasuk);
$stmtMasuk->execute();
$totalMasuk = $stmtMasuk->fetchColumn();

$sqlKeluar = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fuel_stock WHERE jenis = 'Keluar'";
$stmtKeluar = $conn->prepare($sqlKeluar);
$stmtKeluar->execute();
$totalKeluar = $stmtKeluar->fetchColumn();

$sqlUsed = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fueling";
$stmtUsed = $conn->prepare($sqlUsed);
$stmtUsed->execute();
$totalUsed = $stmtUsed->fetchColumn();

$currentStock = $totalMasuk - $totalKeluar - $totalUsed;
?>

<style>
.info-box-number { font-size: 24px; }

/* DataTables Pagination - Clean Style */
.dataTables_wrapper .dataTables_paginate {
    padding: 15px 0;
    float: right;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    display: inline-block;
    padding: 6px 12px;
    margin: 0 2px;
    border-radius: 4px;
    background: #333;
    border: 1px solid #555;
    color: #fff !important;
    cursor: pointer;
    font-size: 14px;
    text-decoration: none;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: #ff9900;
    border-color: #ff9900;
    color: #000 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: #ff9900 !important;
    border-color: #ff9900 !important;
    color: #000 !important;
    font-weight: 600;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover {
    background: #222 !important;
    border-color: #333 !important;
    color: #555 !important;
    cursor: default;
}

/* DataTables Length & Search */
.dataTables_wrapper .dataTables_length {
    float: left;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length label {
    color: #ccc;
}

.dataTables_wrapper .dataTables_length select {
    padding: 5px 10px;
    border-radius: 4px;
    margin: 0 5px;
    min-width: 60px;
}

.dataTables_wrapper .dataTables_filter {
    float: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    padding: 6px 15px;
    border-radius: 15px;
    border: 1px solid #555;
    margin-left: 8px;
    min-width: 200px;
}

/* DataTables Info */
.dataTables_wrapper .dataTables_info {
    float: left;
    padding: 15px 0;
    color: #aaa;
    font-size: 13px;
}

/* Clear float */
.dataTables_wrapper::after {
    content: "";
    display: table;
    clear: both;
}

/* Table Improvements */
.table > tbody > tr > td {
    vertical-align: middle !important;
}

.stock-low {
    color: #dc3545;
}

.stock-ok {
    color: #28a745;
}
</style>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Fuel Management
        <small>Fuel Stock</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Fuel Management</li>
        <li class="active">Fuel Stock</li>
      </ol>
    </section>

    <section class="content">
      <div class="row">
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-green">
            <span class="info-box-icon"><i class="fa fa-plus-circle"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Stok Masuk</span>
              <span class="info-box-number"><?php echo number_format($totalMasuk, 2); ?> L</span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-red">
            <span class="info-box-icon"><i class="fa fa-minus-circle"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Stok Keluar</span>
              <span class="info-box-number"><?php echo number_format($totalKeluar, 2); ?> L</span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-yellow">
            <span class="info-box-icon"><i class="fa fa-fire"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Terpakai (Fueling)</span>
              <span class="info-box-number"><?php echo number_format($totalUsed, 2); ?> L</span>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box bg-aqua">
            <span class="info-box-icon"><i class="fa fa-database"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Stok Tersedia</span>
              <span class="info-box-number <?php echo $currentStock < 1000 ? 'stock-low' : 'stock-ok'; ?>"><?php echo number_format($currentStock, 2); ?> L</span>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <button class="btn btn-success" data-toggle="modal" data-target="#addMasukModal"><i class="fa fa-plus"></i> Stok Masuk</button>
                    <button class="btn btn-danger" data-toggle="modal" data-target="#addKeluarModal"><i class="fa fa-minus"></i> Stok Keluar</button>
                    <button type="button" class="btn btn-box-tool pull-right" data-widget="collapse"><i class="fa fa-minus"></i></button>
                </div>
                <div class="box-body">
                  <div class="table-responsive">
                  <table id="example1" class="table table-bordered table-striped table-hover">
                    <thead>
                    <tr>
                      <th width="3%">No</th>
                      <th>Tanggal</th>
                      <th>Jenis</th>
                      <th>Jumlah Liter</th>
                      <th>Keterangan</th>
                      <th width="10%">Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $sql = "SELECT * FROM m_fuel_stock ORDER BY id DESC";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    $no = 1;
                    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                    <tr>
                      <td><?php echo $no++; ?></td>
                      <td><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                      <td>
                        <?php if($row['jenis'] == 'Masuk'): ?>
                        <span class="label label-success"><i class="fa fa-plus"></i> Masuk</span>
                        <?php else: ?>
                        <span class="label label-danger"><i class="fa fa-minus"></i> Keluar</span>
                        <?php endif; ?>
                      </td>
                      <td><b><?php echo number_format($row['jumlah_liter'], 2); ?></b> L</td>
                      <td><?php echo htmlspecialchars($row['keterangan'] ?? '-'); ?></td>
                      <td>
                          <button class="btn btn-warning btn-xs edit-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-edit"></i></button>
                          <button class="btn btn-danger btn-xs delete-btn" data-id="<?php echo $row['id']; ?>"><i class="fa fa-trash"></i></button>
                      </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                  </table>
                  </div>
                </div>
            </div>
        </div>
      </div>
    </section>
</div>

<!-- Add Masuk Modal -->
<div class="modal fade" id="addMasukModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-green">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-plus"></i> Tambah Stok Masuk</h4>
      </div>
      <form id="addMasukForm">
      <input type="hidden" name="jenis" value="Masuk">
      <div class="modal-body">
        <div class="form-group">
            <label>Tanggal <span class="text-danger">*</span></label>
            <input type="date" name="tanggal" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
        </div>
        <div class="form-group">
            <label>Jumlah Liter <span class="text-danger">*</span></label>
            <input type="number" name="jumlah_liter" class="form-control" value="0" min="0" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Keterangan</label>
            <textarea name="keterangan" class="form-control" rows="2" placeholder="Keterangan..."></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-success">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Add Keluar Modal -->
<div class="modal fade" id="addKeluarModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-red">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-minus"></i> Tambah Stok Keluar</h4>
      </div>
      <form id="addKeluarForm">
      <input type="hidden" name="jenis" value="Keluar">
      <div class="modal-body">
        <div class="form-group">
            <label>Tanggal <span class="text-danger">*</span></label>
            <input type="date" name="tanggal" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
        </div>
        <div class="form-group">
            <label>Jumlah Liter <span class="text-danger">*</span></label>
            <input type="number" name="jumlah_liter" class="form-control" value="0" min="0" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Keterangan</label>
            <textarea name="keterangan" class="form-control" rows="2" placeholder="Keterangan..."></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-danger">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">Edit Stok BBM</h4>
      </div>
      <form id="editForm">
      <input type="hidden" name="id" id="edit_id">
      <div class="modal-body">
        <div class="form-group">
            <label>Tanggal <span class="text-danger">*</span></label>
            <input type="date" name="tanggal" id="edit_tanggal" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Jenis <span class="text-danger">*</span></label>
            <select name="jenis" id="edit_jenis" class="form-control" required>
                <option value="Masuk">Masuk</option>
                <option value="Keluar">Keluar</option>
            </select>
        </div>
        <div class="form-group">
            <label>Jumlah Liter <span class="text-danger">*</span></label>
            <input type="number" name="jumlah_liter" id="edit_jumlah_liter" class="form-control" min="0" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Keterangan</label>
            <textarea name="keterangan" id="edit_keterangan" class="form-control" rows="2" placeholder="Keterangan..."></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<?php include '../footer.php'; ?>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#example1').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "order": [[0, 'asc']]
    });

    // Add Masuk Form Submit
    $('#addMasukForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/FuelStockController.php?action=create',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Add Keluar Form Submit
    $('#addKeluarForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/FuelStockController.php?action=create',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Edit Button Click
    $('.edit-btn').on('click', function() {
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/FuelStockController.php?action=get&id=' + id,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#edit_id').val(data.id);
                $('#edit_tanggal').val(data.tanggal);
                $('#edit_jenis').val(data.jenis);
                $('#edit_jumlah_liter').val(data.jumlah_liter);
                $('#edit_keterangan').val(data.keterangan);
                $('#editModal').modal('show');
            }
        });
    });

    // Edit Form Submit
    $('#editForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../../controller/FuelStockController.php?action=update',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });

    // Delete Button Click
    $('.delete-btn').on('click', function() {
        if(!confirm('Yakin ingin menghapus data ini?')) return;
        var id = $(this).data('id');
        $.ajax({
            url: '../../controller/FuelStockController.php?action=delete',
            type: 'POST',
            data: {id: id},
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });
});
</script>
