<?php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
}
include '../header.php';
include '../sidebar.php';

// Get type units for filter dropdown
$sqlTypeUnits = "SELECT * FROM m_type_unit ORDER BY nama ASC";
$stmtTypeUnits = $conn->prepare($sqlTypeUnits);
$stmtTypeUnits->execute();
$typeUnitList = $stmtTypeUnits->fetchAll(PDO::FETCH_ASSOC);

// Default date range: this month
$defaultDari = date('Y-m-01');
$defaultSampai = date('Y-m-t');
?>

<style>
.info-box-number { font-size: 24px; }

/* DataTables Pagination - Clean Style */
.dataTables_wrapper .dataTables_paginate {
    padding: 15px 0;
    float: right;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    display: inline-block;
    padding: 6px 12px;
    margin: 0 2px;
    border-radius: 4px;
    background: #333;
    border: 1px solid #555;
    color: #fff !important;
    cursor: pointer;
    font-size: 14px;
    text-decoration: none;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: #ff9900;
    border-color: #ff9900;
    color: #000 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: #ff9900 !important;
    border-color: #ff9900 !important;
    color: #000 !important;
    font-weight: 600;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover {
    background: #222 !important;
    border-color: #333 !important;
    color: #555 !important;
    cursor: default;
}

/* DataTables Length & Search */
.dataTables_wrapper .dataTables_length {
    float: left;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length label {
    color: #ccc;
}

.dataTables_wrapper .dataTables_length select {
    padding: 5px 10px;
    border-radius: 4px;
    margin: 0 5px;
    min-width: 60px;
}

.dataTables_wrapper .dataTables_filter {
    float: right;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    padding: 6px 15px;
    border-radius: 15px;
    border: 1px solid #555;
    margin-left: 8px;
    min-width: 200px;
}

/* DataTables Info */
.dataTables_wrapper .dataTables_info {
    float: left;
    padding: 15px 0;
    color: #aaa;
    font-size: 13px;
}

/* Clear float */
.dataTables_wrapper::after {
    content: "";
    display: table;
    clear: both;
}

/* Filter Panel */
.filter-panel {
    background: rgba(255, 153, 0, 0.1);
    border: 1px solid rgba(255, 153, 0, 0.3);
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 20px;
}

.filter-panel .form-group {
    margin-bottom: 10px;
}

.filter-panel label {
    color: #ff9900;
    font-weight: 600;
}

/* Table Improvements */
.table > tbody > tr > td {
    vertical-align: middle !important;
}

/* Select2 Dark Theme */
.select2-container--default .select2-selection--single {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
    height: 38px !important;
    padding: 4px 8px !important;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff !important;
    line-height: 28px !important;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
}
.select2-container--default .select2-dropdown {
    background-color: #2c2c2c !important;
    border: 1px solid #444 !important;
}
.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: #1e1e1e !important;
    border: 1px solid #555 !important;
    color: #fff !important;
}
.select2-container--default .select2-results__option {
    color: #ccc !important;
    background-color: #2c2c2c !important;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #3a3a3a !important;
    color: #ff9900 !important;
}
.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: #ff9900 !important;
    color: #000 !important;
}

/* Summary Cards */
.summary-card {
    background: linear-gradient(135deg, #1e1e1e 0%, #2c2c2c 100%);
    border-radius: 10px;
    padding: 20px;
    text-align: center;
    border: 1px solid #444;
}

.summary-card .number {
    font-size: 32px;
    font-weight: bold;
    color: #ff9900;
}

.summary-card .label {
    color: #aaa;
    font-size: 14px;
}

/* Nav tabs styling */
.nav-tabs {
    border-bottom: 2px solid #444;
    margin-bottom: 20px;
}

.nav-tabs > li > a {
    color: #aaa;
    border: none;
    border-radius: 0;
}

.nav-tabs > li > a:hover {
    background: rgba(255, 153, 0, 0.1);
    border: none;
    color: #ff9900;
}

.nav-tabs > li.active > a,
.nav-tabs > li.active > a:focus,
.nav-tabs > li.active > a:hover {
    background: transparent;
    border: none;
    border-bottom: 3px solid #ff9900;
    color: #ff9900;
    font-weight: 600;
}
</style>

<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Fuel Management
        <small>Fuel Consumption Report</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li>Fuel Management</li>
        <li class="active">Fuel Consumption Report</li>
      </ol>
    </section>

    <section class="content">
      <!-- Filter Panel -->
      <div class="filter-panel">
        <div class="row">
          <div class="col-md-3">
            <div class="form-group">
              <label><i class="fa fa-calendar"></i> Dari Tanggal</label>
              <input type="date" id="filterDari" class="form-control" value="<?php echo $defaultDari; ?>">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label><i class="fa fa-calendar"></i> Sampai Tanggal</label>
              <input type="date" id="filterSampai" class="form-control" value="<?php echo $defaultSampai; ?>">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label><i class="fa fa-tags"></i> Kategori Unit</label>
              <select id="filterType" class="form-control select2-filter" style="width:100%;">
                <option value="">-- Semua Kategori --</option>
                <?php foreach($typeUnitList as $type): ?>
                <option value="<?php echo $type['id']; ?>"><?php echo htmlspecialchars($type['nama']); ?></option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label><i class="fa fa-truck"></i> Unit</label>
              <select id="filterHeq" class="form-control select2-filter" style="width:100%;">
                <option value="">-- Semua Unit --</option>
              </select>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <button type="button" id="applyFilter" class="btn btn-warning"><i class="fa fa-filter"></i> Terapkan Filter</button>
            <button type="button" id="resetFilter" class="btn btn-default"><i class="fa fa-refresh"></i> Reset</button>
            <button type="button" id="exportExcel" class="btn btn-success pull-right"><i class="fa fa-file-excel-o"></i> Export Excel</button>
          </div>
        </div>
      </div>

      <!-- Summary Cards -->
      <div class="row" id="summaryCards">
        <div class="col-md-4">
          <div class="summary-card">
            <div class="number" id="totalPengisian">0</div>
            <div class="label">Total Pengisian</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="summary-card">
            <div class="number" id="totalLiter">0 L</div>
            <div class="label">Total Liter</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="summary-card">
            <div class="number" id="avgLiter">0 L</div>
            <div class="label">Rata-rata/Pengisian</div>
          </div>
        </div>
      </div>

      <br>

      <!-- Tab Navigation -->
      <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab" data-toggle="tab"><i class="fa fa-list"></i> Detail Pengisian</a></li>
        <li role="presentation"><a href="#summary" aria-controls="summary" role="tab" data-toggle="tab"><i class="fa fa-bar-chart"></i> Summary per Unit</a></li>
      </ul>

      <!-- Tab Content -->
      <div class="tab-content">
        <!-- Detail Tab -->
        <div role="tabpanel" class="tab-pane active" id="detail">
          <div class="box box-primary">
            <div class="box-body">
              <div class="table-responsive">
                <table id="detailTable" class="table table-bordered table-striped table-hover">
                  <thead>
                    <tr>
                      <th>No</th>
                      <th>Tanggal</th>
                      <th>Unit</th>
                      <th>Type</th>
                      <th>Driver/Operator</th>
                      <th>Jumlah Liter</th>
                      <th>HM Awal</th>
                      <th>HM Akhir</th>
                      <th>Keterangan</th>
                    </tr>
                  </thead>
                  <tbody id="detailBody">
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <!-- Summary Tab -->
        <div role="tabpanel" class="tab-pane" id="summary">
          <div class="box box-primary">
            <div class="box-body">
              <div class="table-responsive">
                <table id="summaryTable" class="table table-bordered table-striped table-hover">
                  <thead>
                    <tr>
                      <th>No</th>
                      <th>Unit</th>
                      <th>Type</th>
                      <th>Total Pengisian</th>
                      <th>Total Liter</th>
                      <th>Rata-rata Liter</th>
                    </tr>
                  </thead>
                  <tbody id="summaryBody">
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
</div>

<?php include '../footer.php'; ?>

<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2-filter').select2();

    // Cascading dropdown: Type -> HEQ
    $('#filterType').on('change', function() {
        var typeId = $(this).val();
        var heqSelect = $('#filterHeq');
        heqSelect.html('<option value="">-- Semua Unit --</option>');
        
        if(typeId) {
            $.ajax({
                url: '../../controller/FuelReportController.php?action=get_heq_by_type&type_id=' + typeId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $.each(data, function(i, item) {
                        var label = item.nama_unit ? item.no_unit + ' - ' + item.nama_unit : item.no_unit;
                        heqSelect.append('<option value="' + item.id + '">' + label + '</option>');
                    });
                    heqSelect.trigger('change');
                }
            });
        }
    });

    // Load report function
    function loadReport() {
        var dari = $('#filterDari').val();
        var sampai = $('#filterSampai').val();
        var type_id = $('#filterType').val();
        var heq_id = $('#filterHeq').val();

        // Load detail data
        $.ajax({
            url: '../../controller/FuelReportController.php?action=get_report',
            type: 'GET',
            data: { dari: dari, sampai: sampai, type_id: type_id, heq_id: heq_id },
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    var html = '';
                    var totalLiter = 0;
                    var no = 1;
                    
                    $.each(response.data, function(i, row) {
                        totalLiter += parseFloat(row.jumlah_liter);
                        html += '<tr>';
                        html += '<td>' + no++ + '</td>';
                        html += '<td>' + formatDate(row.tanggal) + '</td>';
                        html += '<td><b>' + (row.unit_nama || '-') + '</b></td>';
                        html += '<td><span class="badge" style="background-color:#3c8dbc;">' + (row.type_nama || '-') + '</span></td>';
                        html += '<td>' + (row.user_nama || '-') + ' <small class="text-muted">(' + row.user_role + ')</small></td>';
                        html += '<td><b>' + formatNumber(row.jumlah_liter) + '</b> L</td>';
                        html += '<td>' + (row.hm_awal ? formatNumber(row.hm_awal) : '-') + '</td>';
                        html += '<td>' + (row.hm_akhir ? formatNumber(row.hm_akhir) : '-') + '</td>';
                        html += '<td>' + (row.keterangan || '-') + '</td>';
                        html += '</tr>';
                    });
                    
                    $('#detailBody').html(html);
                    
                    // Update summary cards
                    var count = response.data.length;
                    var avg = count > 0 ? totalLiter / count : 0;
                    $('#totalPengisian').text(count);
                    $('#totalLiter').text(formatNumber(totalLiter) + ' L');
                    $('#avgLiter').text(formatNumber(avg) + ' L');
                    
                    // Reinitialize DataTable
                    if($.fn.DataTable.isDataTable('#detailTable')) {
                        $('#detailTable').DataTable().destroy();
                    }
                    $('#detailTable').DataTable({
                        "responsive": true,
                        "lengthChange": true,
                        "autoWidth": false,
                        "order": [[1, 'desc']]
                    });
                }
            }
        });

        // Load summary data
        $.ajax({
            url: '../../controller/FuelReportController.php?action=get_summary_by_unit',
            type: 'GET',
            data: { dari: dari, sampai: sampai },
            dataType: 'json',
            success: function(response) {
                if(response.status == 'success') {
                    var html = '';
                    var no = 1;
                    
                    $.each(response.data, function(i, row) {
                        html += '<tr>';
                        html += '<td>' + no++ + '</td>';
                        html += '<td><b>' + (row.unit_nama || '-') + '</b></td>';
                        html += '<td><span class="badge" style="background-color:#3c8dbc;">' + (row.type_nama || '-') + '</span></td>';
                        html += '<td>' + row.total_pengisian + '</td>';
                        html += '<td><b>' + formatNumber(row.total_liter) + '</b> L</td>';
                        html += '<td>' + formatNumber(row.avg_liter) + ' L</td>';
                        html += '</tr>';
                    });
                    
                    $('#summaryBody').html(html);
                    
                    // Reinitialize DataTable
                    if($.fn.DataTable.isDataTable('#summaryTable')) {
                        $('#summaryTable').DataTable().destroy();
                    }
                    $('#summaryTable').DataTable({
                        "responsive": true,
                        "lengthChange": true,
                        "autoWidth": false,
                        "order": [[4, 'desc']]
                    });
                }
            }
        });
    }

    // Helper functions
    function formatDate(dateStr) {
        var date = new Date(dateStr);
        return ('0' + date.getDate()).slice(-2) + '/' + ('0' + (date.getMonth() + 1)).slice(-2) + '/' + date.getFullYear();
    }

    function formatNumber(num) {
        return parseFloat(num).toLocaleString('id-ID', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }

    // Apply Filter
    $('#applyFilter').on('click', function() {
        loadReport();
    });

    // Reset Filter
    $('#resetFilter').on('click', function() {
        $('#filterDari').val('<?php echo $defaultDari; ?>');
        $('#filterSampai').val('<?php echo $defaultSampai; ?>');
        $('#filterType').val('').trigger('change');
        $('#filterHeq').val('').trigger('change');
        loadReport();
    });

    // Export Excel (simple implementation)
    $('#exportExcel').on('click', function() {
        var table = document.getElementById('detailTable');
        var html = table.outerHTML;
        var url = 'data:application/vnd.ms-excel,' + encodeURIComponent(html);
        var link = document.createElement('a');
        link.download = 'fuel_consumption_report_' + new Date().toISOString().slice(0,10) + '.xls';
        link.href = url;
        link.click();
    });

    // Initial load
    loadReport();
});
</script>
