<?php
// Admin Dashboard - Hauling System
if(isset($_SESSION['email'])== 0) {
	header('Location: ../../index.php');
}

include '../header.php';
include '../sidebar.php';

// ==========================================
// DATA STATISTICS
// ==========================================

// Master Data Counts
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_type_unit");
$stmt->execute();
$type_unit = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_heq");
$stmt->execute();
$heq = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_area");
$stmt->execute();
$area_count = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pit");
$stmt->execute();
$pit_count = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_material");
$stmt->execute();
$material_count = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_mining_cont");
$stmt->execute();
$mining_cont_count = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// POP Statistics - Today
$today = date('Y-m-d');
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pop WHERE tanggal = :today");
$stmt->execute([':today' => $today]);
$ritase_today = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COALESCE(SUM(jml_tonase), 0) as total FROM m_pop WHERE tanggal = :today");
$stmt->execute([':today' => $today]);
$tonase_today = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pop WHERE tanggal = :today AND status = 3");
$stmt->execute([':today' => $today]);
$selesai_today = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pop WHERE tanggal = :today AND status IN (1,2)");
$stmt->execute([':today' => $today]);
$proses_today = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// POP Statistics - This Month
$monthStart = date('Y-m-01');
$monthEnd = date('Y-m-t');
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pop WHERE tanggal BETWEEN :start AND :end");
$stmt->execute([':start' => $monthStart, ':end' => $monthEnd]);
$ritase_month = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COALESCE(SUM(jml_tonase), 0) as total FROM m_pop WHERE tanggal BETWEEN :start AND :end");
$stmt->execute([':start' => $monthStart, ':end' => $monthEnd]);
$tonase_month = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Data untuk Bar Chart - Ritase 7 hari terakhir
$chartData = [];
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-{$i} days"));
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM m_pop WHERE tanggal = :date");
    $stmt->execute([':date' => $date]);
    $chartData['labels'][] = date('d M', strtotime($date));
    $chartData['ritase'][] = (int)$stmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    $stmt = $conn->prepare("SELECT COALESCE(SUM(jml_tonase), 0) as total FROM m_pop WHERE tanggal = :date");
    $stmt->execute([':date' => $date]);
    $chartData['tonase'][] = (float)$stmt->fetch(PDO::FETCH_ASSOC)['total'];
}

// Data untuk Pie Chart - Material Distribution bulan ini
$stmt = $conn->prepare("SELECT m.nama, COALESCE(SUM(p.jml_tonase), 0) as total 
                        FROM m_pop p 
                        LEFT JOIN m_material m ON p.material_id = m.id 
                        WHERE p.tanggal BETWEEN :start AND :end 
                        GROUP BY p.material_id, m.nama 
                        ORDER BY total DESC LIMIT 5");
$stmt->execute([':start' => $monthStart, ':end' => $monthEnd]);
$materialData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pieLabels = [];
$pieValues = [];
foreach ($materialData as $mat) {
    $pieLabels[] = $mat['nama'] ?? 'Unknown';
    $pieValues[] = (float)$mat['total'];
}

// Data untuk Pie Chart - Status Distribution hari ini
$stmt = $conn->prepare("SELECT status, COUNT(*) as total FROM m_pop WHERE tanggal = :today GROUP BY status");
$stmt->execute([':today' => $today]);
$statusData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$statusLabels = ['Open', 'Pergi', 'Sampai', 'Selesai'];
$statusValues = [0, 0, 0, 0];
foreach ($statusData as $s) {
    $statusValues[$s['status']] = (int)$s['total'];
}

// Data untuk Bar Chart - Top 5 Dump Truck Performance bulan ini
$stmt = $conn->prepare("SELECT COALESCE(h.nama_unit, h.no_unit) as unit_name, COUNT(*) as ritase, COALESCE(SUM(p.jml_tonase), 0) as tonase 
                        FROM m_pop p 
                        LEFT JOIN m_heq h ON p.dt_id = h.id 
                        WHERE p.tanggal BETWEEN :start AND :end AND p.dt_id IS NOT NULL
                        GROUP BY p.dt_id, h.nama_unit, h.no_unit 
                        ORDER BY ritase DESC LIMIT 5");
$stmt->execute([':start' => $monthStart, ':end' => $monthEnd]);
$topDTData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$topDTLabels = [];
$topDTRitase = [];
$topDTTonase = [];
foreach ($topDTData as $dt) {
    $topDTLabels[] = $dt['unit_name'] ?? 'Unknown';
    $topDTRitase[] = (int)$dt['ritase'];
    $topDTTonase[] = (float)$dt['tonase'];
}

// Data untuk Line Chart - Trend Tonase 30 hari
$trendData = [];
for ($i = 29; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-{$i} days"));
    $stmt = $conn->prepare("SELECT COALESCE(SUM(jml_tonase), 0) as total FROM m_pop WHERE tanggal = :date");
    $stmt->execute([':date' => $date]);
    $trendData['labels'][] = date('d', strtotime($date));
    $trendData['tonase'][] = (float)$stmt->fetch(PDO::FETCH_ASSOC)['total'];
}

// Data Area Distribution
$stmt = $conn->prepare("SELECT a.nama, COALESCE(SUM(p.jml_tonase), 0) as total 
                        FROM m_pop p 
                        LEFT JOIN m_area a ON p.area_id = a.id 
                        WHERE p.tanggal BETWEEN :start AND :end 
                        GROUP BY p.area_id, a.nama 
                        ORDER BY total DESC");
$stmt->execute([':start' => $monthStart, ':end' => $monthEnd]);
$areaData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$areaLabels = [];
$areaValues = [];
foreach ($areaData as $area) {
    $areaLabels[] = $area['nama'] ?? 'Unknown';
    $areaValues[] = (float)$area['total'];
}
?>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>

<style>
/* ===============================
   DASHBOARD – LIGHT GRADIENT THEME
=============================== */

/* Stats Container */
.dashboard-stats {
    margin-bottom: 25px;
}

/* ======================
   STAT CARD
====================== */
.stat-card {
    background: linear-gradient(145deg, #ffffff, #f8fafc);
    border-radius: 14px;
    padding: 20px;
    margin-bottom: 20px;
    border-left: 5px solid #ff9900;
    transition: all 0.3s ease;
    box-shadow: 0 10px 30px rgba(15, 23, 42, 0.08);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 15px 35px rgba(255, 153, 0, 0.25);
}

/* Icon */
.stat-card .stat-icon {
    font-size: 46px;
    float: right;
    color: rgba(37, 99, 235, 0.25);
    margin-top: -10px;
}

/* Number */
.stat-card .stat-number {
    font-size: 36px;
    font-weight: 800;
    color: #0f172a;
    line-height: 1.2;
}

/* Label */
.stat-card .stat-label {
    font-size: 13px;
    color: #2563eb;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-top: 6px;
    font-weight: 700;
}

/* Highlight Card */
.stat-card.highlight {
    background: linear-gradient(135deg, #ffb703, #ff9900);
    border-left-color: #2563eb;
}

.stat-card.highlight .stat-number,
.stat-card.highlight .stat-label {
    color: #000;
}

.stat-card.highlight .stat-icon {
    color: rgba(0, 0, 0, 0.25);
}

/* ======================
   CHART BOX
====================== */
.chart-box {
    background: linear-gradient(145deg, #ffffff, #f8fafc);
    border-radius: 14px;
    padding: 22px;
    margin-bottom: 25px;
    border: 1px solid #e5e7eb;
    box-shadow: 0 10px 30px rgba(15, 23, 42, 0.08);
}

.chart-box .chart-title {
    font-size: 18px;
    font-weight: 700;
    color: #2563eb;
    margin-bottom: 18px;
    padding-bottom: 12px;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    align-items: center;
}

.chart-box .chart-title i {
    margin-right: 10px;
    color: #ff9900;
}

.chart-box .chart-title .badge-info {
    margin-left: auto;
    background: linear-gradient(135deg, #ffb703, #ff9900);
    color: #000;
    font-weight: 700;
    padding: 6px 14px;
    border-radius: 20px;
}

/* ======================
   WELCOME BOX
====================== */
.welcome-box {
    background: linear-gradient(
        135deg,
        #2563eb 0%,
        #3b82f6 50%,
        #ffb703 100%
    );
    border-radius: 16px;
    padding: 26px 32px;
    margin-bottom: 25px;
    color: #000;
    position: relative;
    overflow: hidden;
}

.welcome-box::before {
    content: '';
    position: absolute;
    top: -40%;
    right: -15%;
    width: 60%;
    height: 200%;
    background: rgba(255,255,255,0.18);
    transform: rotate(20deg);
}

.welcome-box h2 {
    margin: 0 0 10px;
    font-weight: 800;
    font-size: 24px;
    color: #000 !important;
}

.welcome-box p {
    margin: 0;
    font-size: 15px;
    color: #000 !important;
    opacity: 0.9;
}

.welcome-box .welcome-icon {
    position: absolute;
    right: 30px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 64px;
    opacity: 0.2;
}

/* ======================
   QUICK LINK
====================== */
.quick-link {
    display: flex;
    align-items: center;
    padding: 16px;
    background: #ffffff;
    border-radius: 12px;
    margin-bottom: 12px;
    text-decoration: none;
    color: #0f172a;
    transition: all 0.3s ease;
    border: 1px solid #e5e7eb;
    box-shadow: 0 6px 20px rgba(15, 23, 42, 0.06);
}

.quick-link:hover {
    background: linear-gradient(135deg, #ffb703, #ff9900);
    border-color: #ff9900;
    transform: translateX(6px);
    text-decoration: none;
    color: #000;
}

.quick-link i {
    font-size: 24px;
    margin-right: 15px;
    color: #2563eb;
    width: 30px;
    text-align: center;
}

.quick-link:hover i {
    color: #000;
}

.quick-link span {
    font-weight: 600;
}

/* ======================
   PROGRESS
====================== */
.progress-stat {
    margin-bottom: 16px;
}

.progress-stat .stat-info {
    display: flex;
    justify-content: space-between;
    margin-bottom: 6px;
    color: #475569;
    font-weight: 600;
}

.progress-stat .progress {
    height: 9px;
    background: #e5e7eb;
    border-radius: 6px;
    overflow: hidden;
}

.progress-stat .progress-bar {
    background: linear-gradient(90deg, #2563eb, #ffb703);
    border-radius: 6px;
}

/* ======================
   CHART SIZE
====================== */
.chart-container {
    position: relative;
    height: 280px;
    width: 100%;
}

.chart-container-small {
    position: relative;
    height: 220px;
    width: 100%;
}

/* ======================
   ANIMATION
====================== */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(18px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.stat-card,
.chart-box {
    animation: fadeInUp 0.5s ease forwards;
}

/* ======================
   INFO BOX
====================== */
.info-box {
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(15, 23, 42, 0.08);
}

/* ======================
   DATE BADGE
====================== */
.date-badge {
    background: linear-gradient(135deg, #ffb703, #ff9900);
    color: #000;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 700;
    display: inline-block;
    margin-bottom: 15px;
}
</style>


<div class="content-wrapper">
    <section class="content-header">
      <h1>
        Dashboard
        <small>Hauling System Analytics</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Dashboard</li>
      </ol>
    </section>

    <section class="content">
      
      <!-- Welcome Box -->
      <div class="welcome-box">
        <i class="fa fa-truck welcome-icon"></i>
        <h2>Selamat Datang, <?php echo isset($_SESSION['nama']) ? $_SESSION['nama'] : 'Admin'; ?>!</h2>
        <p>Dashboard Hauling System menampilkan ringkasan operasional produksi dan ritase harian. Data ter-update: <?php echo date('d F Y, H:i'); ?> WIT</p>
      </div>

      <!-- Date Badge -->
      <div class="date-badge">
        <i class="fa fa-calendar"></i> Data Hari Ini: <?php echo date('l, d F Y'); ?>
      </div>

      <!-- Today's Statistics -->
      <div class="row dashboard-stats">
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card highlight">
            <i class="fa fa-truck stat-icon"></i>
            <div class="stat-number"><?php echo number_format($ritase_today); ?></div>
            <div class="stat-label">Ritase Hari Ini</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-cube stat-icon"></i>
            <div class="stat-number"><?php echo number_format($tonase_today, 0); ?></div>
            <div class="stat-label">Tonase Hari Ini (Ton)</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-check-circle stat-icon"></i>
            <div class="stat-number"><?php echo number_format($selesai_today); ?></div>
            <div class="stat-label">Selesai</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-clock-o stat-icon"></i>
            <div class="stat-number"><?php echo number_format($proses_today); ?></div>
            <div class="stat-label">Dalam Proses</div>
          </div>
        </div>
      </div>

      <!-- Monthly Statistics -->
      <div class="row dashboard-stats">
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-calendar stat-icon"></i>
            <div class="stat-number"><?php echo number_format($ritase_month); ?></div>
            <div class="stat-label">Ritase Bulan Ini</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-balance-scale stat-icon"></i>
            <div class="stat-number"><?php echo number_format($tonase_month, 0); ?></div>
            <div class="stat-label">Tonase Bulan Ini (Ton)</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-cogs stat-icon"></i>
            <div class="stat-number"><?php echo number_format($heq); ?></div>
            <div class="stat-label">Total Heavy Equipment</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6">
          <div class="stat-card">
            <i class="fa fa-building stat-icon"></i>
            <div class="stat-number"><?php echo number_format($mining_cont_count); ?></div>
            <div class="stat-label">Mining Contractors</div>
          </div>
        </div>
      </div>

      <!-- Charts Row 1 -->
      <div class="row">
        <!-- Bar Chart - Ritase 7 Hari -->
        <div class="col-lg-8 col-md-8">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-bar-chart"></i> Ritase & Tonase 7 Hari Terakhir
              <span class="badge-info"><?php echo array_sum($chartData['ritase']); ?> Total Ritase</span>
            </div>
            <div class="chart-container">
              <canvas id="ritaseChart"></canvas>
            </div>
          </div>
        </div>
        
        <!-- Pie Chart - Status Hari Ini -->
        <div class="col-lg-4 col-md-4">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-pie-chart"></i> Status Ritase Hari Ini
            </div>
            <div class="chart-container-small">
              <canvas id="statusChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Charts Row 2 -->
      <div class="row">
        <!-- Pie Chart - Material Distribution -->
        <div class="col-lg-4 col-md-4">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-pie-chart"></i> Distribusi Material (Bulan Ini)
            </div>
            <div class="chart-container-small">
              <canvas id="materialChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Bar Chart - Top DT Performance -->
        <div class="col-lg-4 col-md-4">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-trophy"></i> Top 5 Dump Truck
            </div>
            <div class="chart-container-small">
              <canvas id="topDTChart"></canvas>
            </div>
          </div>
        </div>

        <!-- Doughnut Chart - Area Distribution -->
        <div class="col-lg-4 col-md-4">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-map-marker"></i> Tonase per Area
            </div>
            <div class="chart-container-small">
              <canvas id="areaChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Charts Row 3 - Full Width Trend -->
      <div class="row">
        <div class="col-xs-12">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-line-chart"></i> Trend Tonase 30 Hari Terakhir
              <span class="badge-info"><?php echo number_format(array_sum($trendData['tonase']), 0); ?> Total Ton</span>
            </div>
            <div class="chart-container">
              <canvas id="trendChart"></canvas>
            </div>
          </div>
        </div>
      </div>

      <!-- Quick Links & Master Data Stats -->
      <div class="row">
        <!-- Quick Links -->
        <div class="col-lg-4 col-md-6">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-link"></i> Quick Links
            </div>
            <a href="../m_pop/" class="quick-link">
              <i class="fa fa-plus-circle"></i>
              <span>Tambah POP Baru</span>
            </a>
            <a href="../m_heq/" class="quick-link">
              <i class="fa fa-truck"></i>
              <span>Kelola Heavy Equipment</span>
            </a>
            <a href="../m_material/" class="quick-link">
              <i class="fa fa-cubes"></i>
              <span>Master Material</span>
            </a>
            <a href="../pengaturan/" class="quick-link">
              <i class="fa fa-gear"></i>
              <span>Pengaturan Sistem</span>
            </a>
          </div>
        </div>

        <!-- Master Data Overview -->
        <div class="col-lg-4 col-md-6">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-database"></i> Master Data Overview
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Type Unit</span>
                <span><?php echo $type_unit; ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo min($type_unit * 10, 100); ?>%"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Heavy Equipment</span>
                <span><?php echo $heq; ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo min($heq * 5, 100); ?>%"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Area</span>
                <span><?php echo $area_count; ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo min($area_count * 20, 100); ?>%"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Pit</span>
                <span><?php echo $pit_count; ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo min($pit_count * 20, 100); ?>%"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Material</span>
                <span><?php echo $material_count; ?></span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo min($material_count * 15, 100); ?>%"></div>
              </div>
            </div>
          </div>
        </div>

        <!-- Today's Summary -->
        <div class="col-lg-4 col-md-12">
          <div class="chart-box">
            <div class="chart-title">
              <i class="fa fa-info-circle"></i> Ringkasan Hari Ini
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Open/Menunggu</span>
                <span><?php echo $statusValues[0]; ?> ritase</span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo $ritase_today > 0 ? ($statusValues[0] / $ritase_today * 100) : 0; ?>%; background: #6c757d;"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Sedang Pergi</span>
                <span><?php echo $statusValues[1]; ?> ritase</span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo $ritase_today > 0 ? ($statusValues[1] / $ritase_today * 100) : 0; ?>%; background: #17a2b8;"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Sudah Sampai</span>
                <span><?php echo $statusValues[2]; ?> ritase</span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo $ritase_today > 0 ? ($statusValues[2] / $ritase_today * 100) : 0; ?>%; background: #ffc107;"></div>
              </div>
            </div>
            
            <div class="progress-stat">
              <div class="stat-info">
                <span>Selesai</span>
                <span><?php echo $statusValues[3]; ?> ritase</span>
              </div>
              <div class="progress">
                <div class="progress-bar" style="width: <?php echo $ritase_today > 0 ? ($statusValues[3] / $ritase_today * 100) : 0; ?>%; background: #28a745;"></div>
              </div>
            </div>

            <hr style="border-color: #444; margin: 15px 0;">
            
            <div style="display: flex; justify-content: space-between; color: #ccc; font-size: 14px;">
              <span>Rata-rata Tonase/Ritase:</span>
              <strong style="color: #ff9900;"><?php echo $ritase_today > 0 ? number_format($tonase_today / $ritase_today, 2) : 0; ?> Ton</strong>
            </div>
          </div>
        </div>
      </div>

    </section>
</div>

<?php include '../footer.php'; ?>

<script>
// Chart.js Global Configuration
Chart.defaults.color = '#cccccc';
Chart.defaults.borderColor = '#444444';

// Color Palette
const colors = {
    orange: '#ff9900',
    orangeLight: '#ffb84d',
    orangeDark: '#cc7a00',
    green: '#28a745',
    blue: '#17a2b8',
    yellow: '#ffc107',
    red: '#dc3545',
    gray: '#6c757d',
    white: '#ffffff',
    darkBg: '#1a1a1a'
};

const chartColors = [
    'rgba(255, 153, 0, 0.9)',
    'rgba(40, 167, 69, 0.9)',
    'rgba(23, 162, 184, 0.9)',
    'rgba(255, 193, 7, 0.9)',
    'rgba(220, 53, 69, 0.9)',
    'rgba(108, 117, 125, 0.9)'
];

// 1. Ritase & Tonase Bar Chart
const ritaseCtx = document.getElementById('ritaseChart').getContext('2d');
new Chart(ritaseCtx, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($chartData['labels']); ?>,
        datasets: [
            {
                label: 'Ritase',
                data: <?php echo json_encode($chartData['ritase']); ?>,
                backgroundColor: 'rgba(255, 153, 0, 0.8)',
                borderColor: colors.orange,
                borderWidth: 2,
                borderRadius: 6,
                yAxisID: 'y'
            },
            {
                label: 'Tonase (Ton)',
                data: <?php echo json_encode($chartData['tonase']); ?>,
                type: 'line',
                borderColor: colors.green,
                backgroundColor: 'rgba(40, 167, 69, 0.2)',
                borderWidth: 3,
                tension: 0.4,
                fill: true,
                yAxisID: 'y1'
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: {
            mode: 'index',
            intersect: false,
        },
        plugins: {
            legend: {
                labels: {
                    color: colors.white,
                    font: { size: 12 }
                }
            }
        },
        scales: {
            y: {
                type: 'linear',
                position: 'left',
                title: { display: true, text: 'Ritase', color: colors.orange },
                grid: { color: '#333' },
                ticks: { color: colors.orange }
            },
            y1: {
                type: 'linear',
                position: 'right',
                title: { display: true, text: 'Tonase (Ton)', color: colors.green },
                grid: { drawOnChartArea: false },
                ticks: { color: colors.green }
            },
            x: {
                grid: { color: '#333' },
                ticks: { color: '#ccc' }
            }
        }
    }
});

// 2. Status Pie Chart
const statusCtx = document.getElementById('statusChart').getContext('2d');
new Chart(statusCtx, {
    type: 'doughnut',
    data: {
        labels: ['Open', 'Pergi', 'Sampai', 'Selesai'],
        datasets: [{
            data: <?php echo json_encode($statusValues); ?>,
            backgroundColor: [
                'rgba(108, 117, 125, 0.9)',
                'rgba(23, 162, 184, 0.9)',
                'rgba(255, 193, 7, 0.9)',
                'rgba(40, 167, 69, 0.9)'
            ],
            borderColor: '#1a1a1a',
            borderWidth: 3
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
                labels: {
                    color: colors.white,
                    padding: 15,
                    font: { size: 11 }
                }
            }
        }
    }
});

// 3. Material Distribution Pie Chart
const materialCtx = document.getElementById('materialChart').getContext('2d');
new Chart(materialCtx, {
    type: 'pie',
    data: {
        labels: <?php echo json_encode($pieLabels); ?>,
        datasets: [{
            data: <?php echo json_encode($pieValues); ?>,
            backgroundColor: chartColors,
            borderColor: '#1a1a1a',
            borderWidth: 3
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
                labels: {
                    color: colors.white,
                    padding: 10,
                    font: { size: 10 }
                }
            }
        }
    }
});

// 4. Top Dump Truck Bar Chart
const topDTCtx = document.getElementById('topDTChart').getContext('2d');
new Chart(topDTCtx, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($topDTLabels); ?>,
        datasets: [{
            label: 'Ritase',
            data: <?php echo json_encode($topDTRitase); ?>,
            backgroundColor: 'rgba(255, 153, 0, 0.8)',
            borderColor: colors.orange,
            borderWidth: 2,
            borderRadius: 4
        }]
    },
    options: {
        indexAxis: 'y',
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false }
        },
        scales: {
            x: {
                grid: { color: '#333' },
                ticks: { color: '#ccc' }
            },
            y: {
                grid: { display: false },
                ticks: { color: '#ccc', font: { size: 10 } }
            }
        }
    }
});

// 5. Area Distribution Doughnut Chart
const areaCtx = document.getElementById('areaChart').getContext('2d');
new Chart(areaCtx, {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode($areaLabels); ?>,
        datasets: [{
            data: <?php echo json_encode($areaValues); ?>,
            backgroundColor: chartColors,
            borderColor: '#1a1a1a',
            borderWidth: 3
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
                labels: {
                    color: colors.white,
                    padding: 10,
                    font: { size: 10 }
                }
            }
        }
    }
});

// 6. Trend Line Chart
const trendCtx = document.getElementById('trendChart').getContext('2d');
new Chart(trendCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($trendData['labels']); ?>,
        datasets: [{
            label: 'Tonase Harian (Ton)',
            data: <?php echo json_encode($trendData['tonase']); ?>,
            borderColor: colors.orange,
            backgroundColor: 'rgba(255, 153, 0, 0.1)',
            borderWidth: 3,
            tension: 0.4,
            fill: true,
            pointBackgroundColor: colors.orange,
            pointBorderColor: '#fff',
            pointBorderWidth: 2,
            pointRadius: 4,
            pointHoverRadius: 6
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                labels: {
                    color: colors.white,
                    font: { size: 12 }
                }
            }
        },
        scales: {
            x: {
                grid: { color: '#333' },
                ticks: { color: '#ccc', maxRotation: 0 }
            },
            y: {
                grid: { color: '#333' },
                ticks: { color: '#ccc' },
                beginAtZero: true
            }
        }
    }
});

// Force sidebar to be collapsed (start hidden/icon-only) on dashboard load
$(document).ready(function() {
    $('body').addClass('sidebar-collapse');
    $('body').removeClass('sidebar-open');
    // Trigger window resize to ensure layout adjusts correctly
    $(window).trigger('resize');
});
</script>
