<?php
// View/admin/exam_preview.php
include '../../config.php';
if(!isset($_SESSION['email'])) {
    header('Location: ../../index.php');
    exit;
}

// Get parameters
$type = isset($_GET['type']) ? $_GET['type'] : '';
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if(!in_array($type, ['paket_soal', 'simulasi_cepat', 'bank_soal']) || $id <= 0) {
    die('Invalid parameters');
}

// Get exam info and questions
if($type == 'paket_soal') {
    $stmt = $conn->prepare("SELECT * FROM m_paket_soal WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $exam = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$exam) die('Exam package not found');
    
    // Get questions
    $stmt = $conn->prepare("SELECT m_soal.* FROM m_soal 
        INNER JOIN m_soalpaket ON m_soal.id = m_soalpaket.soal_id 
        WHERE m_soalpaket.paketsoal_id = :id 
        ORDER BY m_soalpaket.id ASC");
    $stmt->execute(['id' => $id]);
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} elseif($type == 'simulasi_cepat') {
    $stmt = $conn->prepare("SELECT * FROM m_simulasi_cepat WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $exam = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$exam) die('Simulation not found');
    
    // Get questions
    $stmt = $conn->prepare("SELECT m_soal.* FROM m_soal 
        INNER JOIN m_soalsim ON m_soal.id = m_soalsim.soal_id 
        WHERE m_soalsim.simcepat_id = :id 
        ORDER BY m_soalsim.id ASC");
    $stmt->execute(['id' => $id]);
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} else { // bank_soal
    $stmt = $conn->prepare("SELECT * FROM m_bank_soal WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $exam = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$exam) die('Bank Soal not found');
    
    // Bank soal doesn't have waktu_menit, set default
    if(!isset($exam['waktu_menit'])) {
        $exam['waktu_menit'] = 60; // Default 60 minutes
    }
    
    // Get questions directly from m_soal where m_bank_soal_id matches
    $stmt = $conn->prepare("SELECT * FROM m_soal WHERE m_bank_soal_id = :id ORDER BY id ASC");
    $stmt->execute(['id' => $id]);
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$total_soal = count($questions);
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Preview: <?php echo htmlspecialchars($exam['nama']); ?> | HJSK</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="../../public/bower_components/bootstrap/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../../public/bower_components/font-awesome/css/font-awesome.min.css">
  <link rel="stylesheet" href="../../public/dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="../../public/dist/css/skins/_all-skins.min.css">
  
  <style>
      .preview-banner {
          background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
          color: white;
          padding: 10px 15px;
          text-align: center;
          position: fixed;
          bottom: 0;
          left: 0;
          right: 0;
          z-index: 1000;
          box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
      }
      body {
          padding-bottom: 70px; /* Space for fixed bottom banner */
      }
      .soal-nav {
          display: inline-block;
          width: 40px;
          height: 40px;
          line-height: 40px;
          text-align: center;
          border: 1px solid #ddd;
          margin: 5px;
          cursor: pointer;
          border-radius: 5px;
      }
      .soal-nav.active {
          background-color: #3c8dbc;
          color: white;
      }
      .question-box {
          display: none;
      }
      .question-box.active {
          display: block;
      }
  </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">
<div class="wrapper">

  <!-- Preview Banner - Fixed at Bottom -->
  <div class="preview-banner">
      <div class="container">
          <div class="row">
              <div class="col-xs-8 col-md-9 text-left">
                  <span style="font-size: 14px;">
                      <i class="fa fa-eye"></i> <strong>PREVIEW MODE</strong> - <?php echo htmlspecialchars($exam['nama']); ?>
                      <span class="hidden-xs" style="opacity: 0.85; margin-left: 10px;">| Jawaban tidak akan disimpan</span>
                  </span>
              </div>
              <div class="col-xs-4 col-md-3 text-right">
                  <button onclick="window.close()" class="btn btn-sm" style="background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3);">
                      <i class="fa fa-times"></i> <span class="hidden-xs">Close</span>
                  </button>
              </div>
          </div>
      </div>
  </div>

  <header class="main-header">
    <nav class="navbar navbar-static-top">
      <div class="container">
        <div class="navbar-header">
          <a href="#" class="navbar-brand"><b>Ujian</b>Online</a>
        </div>
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                <li><a href="#"><i class="fa fa-clock-o"></i> <span id="timer"><?php echo $exam['waktu_menit']; ?>:00:00</span></a></li>
            </ul>
        </div>
      </div>
    </nav>
  </header>

  <div class="content-wrapper">
    <div class="container">
      <section class="content">
        <div class="row">
            <!-- Question Area -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-body" style="min-height: 400px;">
                        <?php 
                        if($total_soal == 0) {
                            echo '<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> Tidak ada soal dalam paket/simulasi ini.</div>';
                        } else {
                            $no = 1;
                            foreach($questions as $q) {
                        ?>
                        <div class="question-box" id="q_<?php echo $no; ?>" data-id="<?php echo $q['id']; ?>">
                            <h4>Soal No. <?php echo $no; ?></h4>
                            <hr>
                            <p style="font-size: 16px;"><?php echo $q['pertanyaan']; ?></p>
                            
                            <?php if(!empty($q['file']) && file_exists('../../assets/img/soal/' . $q['file'])): ?>
                                <div style="margin-bottom: 20px;">
                                    <img src="../../assets/img/soal/<?php echo $q['file']; ?>" class="img-responsive" style="max-height: 400px; border: 1px solid #ddd; padding: 5px;" alt="Question Image">
                                </div>
                            <?php endif; ?>

                            <?php if($q['tipe_soal'] == 1 || $q['tipe_soal'] == 3): ?>
                                <?php 
                                    $inputType = ($q['tipe_soal'] == 1) ? 'radio' : 'checkbox';
                                ?>
                                <div class="form-group">
                                    <div class="row"> 
                                        <?php 
                                        $opsi = ['A', 'B', 'C', 'D', 'E'];
                                        foreach($opsi as $opt): 
                                            $val = $q['opsi_' . strtolower($opt)];
                                            $file = $q['file_' . strtolower($opt)];
                                            
                                            // Show option if value exists OR file exists
                                            if(!empty($val) || !empty($file)): 
                                        ?>
                                        <div class="col-md-12" style="margin-bottom: 15px;">
                                            <div style="display: flex; align-items: flex-start;">
                                                <div style="margin-right: 15px;">
                                                     <label class="btn btn-default btn-answer" data-type="<?php echo $inputType; ?>" style="width: 45px; height: 45px; line-height: 32px; border-radius: 5px; font-weight: bold; font-size: 18px;">
                                                        <input type="<?php echo $inputType; ?>" name="ans_<?php echo $q['id']; ?><?php echo ($inputType=='checkbox')?'[]':''; ?>" value="<?php echo $opt; ?>" autocomplete="off"> <?php echo $opt; ?>
                                                    </label>
                                                </div>
                                                <div>
                                                    <?php if(!empty($file) && file_exists('../../assets/img/soal/' . $file)): ?>
                                                        <div style="margin-bottom: 5px;">
                                                            <img src="../../assets/img/soal/<?php echo $file; ?>" style="max-height: 150px; border: 1px solid #eee; padding: 3px;" class="img-thumbnail" alt="Option Image">
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if(!empty($val)): ?>
                                                        <div style="font-size: 16px; padding-top: 10px;"><?php echo $val; ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; endforeach; ?>
                                    </div>

                                    <?php if($q['tipe_soal'] == 3): ?>
                                    <p class="help-block text-muted small"><i class="fa fa-info-circle"></i> Pilih lebih dari satu jawaban (misal: A dan C)</p>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="form-group">
                                    <textarea name="ans_<?php echo $q['id']; ?>" class="form-control" rows="5" placeholder="Tulis jawaban essay Anda..." disabled></textarea>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php $no++; } } ?>
                    </div>
                    <?php if($total_soal > 0): ?>
                    <div class="box-footer">
                        <button class="btn btn-default" id="btn_prev"><i class="fa fa-arrow-left"></i> Sebelumnya</button>
                        <button class="btn btn-primary pull-right" id="btn_next">Selanjutnya <i class="fa fa-arrow-right"></i></button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Navigation Area -->
             <div class="col-md-4">
                 <div class="box box-solid">
                     <div class="box-header with-border">
                         <h3 class="box-title">Navigasi Soal</h3>
                     </div>
                     <div class="box-body text-center">
                         <?php for($i=1; $i<=$total_soal; $i++): ?>
                         <div class="soal-nav" onclick="showQuestion(<?php echo $i; ?>)" id="nav_<?php echo $i; ?>"><?php echo $i; ?></div>
                         <?php endfor; ?>
                     </div>
                 </div>
                 
                 <div class="box box-warning">
                     <div class="box-header with-border">
                         <h3 class="box-title"><i class="fa fa-info-circle"></i> Informasi</h3>
                     </div>
                     <div class="box-body">
                         <p><strong>Nama:</strong> <?php echo htmlspecialchars($exam['nama']); ?></p>
                         <p><strong>Deskripsi:</strong> <?php echo htmlspecialchars($exam['des']); ?></p>
                         <p><strong>Waktu:</strong> <?php echo $exam['waktu_menit']; ?> menit</p>
                         <p><strong>Jumlah Soal:</strong> <?php echo $total_soal; ?></p>
                         <hr>
                         <p class="text-muted small"><i class="fa fa-info-circle"></i> Mode preview: jawaban tidak akan disimpan</p>
                     </div>
                 </div>
             </div>
        </div>
      </section>
    </div>
  </div>
  
  <footer class="main-footer">
    <div class="container">
      <div class="pull-right hidden-xs">
        <b>Preview Mode</b>
      </div>
      <strong>Copyright &copy; 2026.</strong> All rights reserved.
    </div>
  </footer>
</div>

<script src="../../public/bower_components/jquery/dist/jquery.min.js"></script>
<script src="../../public/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<script>
var currentQ = 1;
var totalQ = <?php echo $total_soal; ?>;

$(document).ready(function(){
    if(totalQ > 0) {
        showQuestion(1);
    }

    $('#btn_prev').click(function(){
        if(currentQ > 1) showQuestion(currentQ - 1);
    });

    $('#btn_next').click(function(){
        if(currentQ < totalQ) {
            showQuestion(currentQ + 1);
        }
    });

    // Handle Button Click Style Toggle (Preview only - visual feedback)
    $(document).on('click', '.btn-answer', function(e) {
        var btn = $(this);
        var type = btn.data('type');
        var input = btn.find('input');

        setTimeout(function(){
            if(type == 'radio') {
                if(input.prop('checked')) {
                    // Visual update for Radio
                    $('input[name="'+input.attr('name')+'"]').each(function(){
                        $(this).closest('.btn-answer').removeClass('btn-success active').addClass('btn-default');
                    });
                    
                    btn.removeClass('btn-default').addClass('btn-success active');
                }
            } else { // Checkbox
                // Visual Update for Checkbox
                if(input.prop('checked')) {
                    btn.removeClass('btn-default').addClass('btn-success active');
                } else {
                    btn.removeClass('btn-success active').addClass('btn-default');
                }
            }
        }, 10);
    });
});

function showQuestion(num) {
    $('.question-box').removeClass('active');
    $('.soal-nav').removeClass('active');
    
    $('#q_'+num).addClass('active');
    $('#nav_'+num).addClass('active');
    
    currentQ = num;
    
    if(currentQ == 1) $('#btn_prev').attr('disabled', true);
    else $('#btn_prev').attr('disabled', false);

    if(currentQ == totalQ) {
        $('#btn_next').html('<i class="fa fa-check"></i> Last Question').removeClass('btn-primary').addClass('btn-success').attr('disabled', true);
    } else {
        $('#btn_next').html('Selanjutnya <i class="fa fa-arrow-right"></i>').removeClass('btn-success').addClass('btn-primary').attr('disabled', false);
    }
}
</script>

</body>
</html>
