<?php
/**
 * Update m_heq Table
 * Menambah kolom: nama_unit (VARCHAR 255) dan mining_cont_id (INT)
 */

include '../config.php';

try {
    // Add nama_unit column
    $sql1 = "ALTER TABLE m_heq ADD COLUMN IF NOT EXISTS `nama_unit` VARCHAR(255) NULL AFTER `no_unit`";
    $conn->exec($sql1);
    echo "<p style='color: green;'>✅ Kolom nama_unit berhasil ditambahkan!</p>";
    
} catch (PDOException $e) {
    // Column might already exist, try different approach for MySQL < 8.0
    try {
        $check = $conn->query("SHOW COLUMNS FROM m_heq LIKE 'nama_unit'")->fetch();
        if (!$check) {
            $conn->exec("ALTER TABLE m_heq ADD COLUMN `nama_unit` VARCHAR(255) NULL AFTER `no_unit`");
            echo "<p style='color: green;'>✅ Kolom nama_unit berhasil ditambahkan!</p>";
        } else {
            echo "<p style='color: blue;'>ℹ️ Kolom nama_unit sudah ada.</p>";
        }
    } catch (PDOException $e2) {
        echo "<p style='color: red;'>❌ Error nama_unit: " . $e2->getMessage() . "</p>";
    }
}

try {
    // Add mining_cont_id column
    $check = $conn->query("SHOW COLUMNS FROM m_heq LIKE 'mining_cont_id'")->fetch();
    if (!$check) {
        $conn->exec("ALTER TABLE m_heq ADD COLUMN `mining_cont_id` INT(11) NULL AFTER `nama_unit`");
        echo "<p style='color: green;'>✅ Kolom mining_cont_id berhasil ditambahkan!</p>";
    } else {
        echo "<p style='color: blue;'>ℹ️ Kolom mining_cont_id sudah ada.</p>";
    }
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Error mining_cont_id: " . $e->getMessage() . "</p>";
}

echo "<br><h4>Struktur Tabel m_heq sekarang:</h4>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th></tr>";
$columns = $conn->query("DESCRIBE m_heq")->fetchAll(PDO::FETCH_ASSOC);
foreach ($columns as $col) {
    echo "<tr><td>{$col['Field']}</td><td>{$col['Type']}</td><td>{$col['Null']}</td><td>{$col['Key']}</td></tr>";
}
echo "</table>";

echo "<br><a href='../view/m_heq/'>➡️ Buka Halaman Heavy Equipment</a>";
?>
