<?php
/**
 * Setup Mining Contractor Table
 * Tabel: m_mining_cont
 * Kolom: id, nama, des, hp, pic, alamat, codx, created_at, updated_at
 */

include '../config.php';

try {
    // Create m_mining_cont table
    $sql = "CREATE TABLE IF NOT EXISTS `m_mining_cont` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `nama` VARCHAR(255) NOT NULL COMMENT 'Nama Mining Contractor',
        `des` TEXT NULL COMMENT 'Deskripsi',
        `hp` VARCHAR(50) NULL COMMENT 'Nomor HP/Telepon',
        `pic` VARCHAR(255) NULL COMMENT 'Person In Charge',
        `alamat` TEXT NULL COMMENT 'Alamat',
        `codx` VARCHAR(100) NULL COMMENT 'Kode Contractor',
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    
    $conn->exec($sql);
    echo "<h3 style='color: green;'>✅ Tabel m_mining_cont berhasil dibuat!</h3>";
    
    // Check if table is empty, insert sample data
    $check = $conn->query("SELECT COUNT(*) FROM m_mining_cont")->fetchColumn();
    if ($check == 0) {
        $sampleData = [
            ['nama' => 'PT. Tambang Jaya Abadi', 'des' => 'Kontraktor tambang batu bara', 'hp' => '08123456789', 'pic' => 'Budi Santoso', 'alamat' => 'Jl. Industri No. 1, Samarinda', 'codx' => 'TJA-001'],
            ['nama' => 'CV. Mineral Mandiri', 'des' => 'Kontraktor pertambangan mineral', 'hp' => '08987654321', 'pic' => 'Andi Wijaya', 'alamat' => 'Jl. Tambang Raya No. 5, Balikpapan', 'codx' => 'MM-002'],
        ];
        
        $stmt = $conn->prepare("INSERT INTO m_mining_cont (nama, des, hp, pic, alamat, codx) VALUES (:nama, :des, :hp, :pic, :alamat, :codx)");
        foreach ($sampleData as $data) {
            $stmt->execute($data);
        }
        echo "<p style='color: blue;'>📝 Sample data berhasil ditambahkan (2 records)</p>";
    }
    
    echo "<h4>Struktur Tabel:</h4>";
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>Kolom</th><th>Tipe</th><th>Keterangan</th></tr>";
    echo "<tr><td>id</td><td>INT(11)</td><td>Primary Key, Auto Increment</td></tr>";
    echo "<tr><td>nama</td><td>VARCHAR(255)</td><td>Nama Mining Contractor</td></tr>";
    echo "<tr><td>des</td><td>TEXT</td><td>Deskripsi</td></tr>";
    echo "<tr><td>hp</td><td>VARCHAR(50)</td><td>Nomor HP/Telepon</td></tr>";
    echo "<tr><td>pic</td><td>VARCHAR(255)</td><td>Person In Charge</td></tr>";
    echo "<tr><td>alamat</td><td>TEXT</td><td>Alamat</td></tr>";
    echo "<tr><td>codx</td><td>VARCHAR(100)</td><td>Kode Contractor</td></tr>";
    echo "<tr><td>created_at</td><td>DATETIME</td><td>Tanggal Dibuat</td></tr>";
    echo "<tr><td>updated_at</td><td>DATETIME</td><td>Tanggal Diupdate</td></tr>";
    echo "</table>";
    
    echo "<br><a href='../view/m_mining_cont/'>➡️ Buka Halaman Mining Contractor</a>";
    
} catch (PDOException $e) {
    echo "<h3 style='color: red;'>❌ Error: " . $e->getMessage() . "</h3>";
}
?>
