<?php
include '../config.php';

echo "<h2>Setup Master POP (Point of Production)</h2>";

try {
    $conn->exec("
        CREATE TABLE IF NOT EXISTS m_pop (
            id INT AUTO_INCREMENT PRIMARY KEY,
            area_id INT,
            pit_id INT,
            dt_id INT COMMENT 'Dump Truck ID',
            tanggal DATE NOT NULL,
            jam_datang TIME,
            exca_id INT COMMENT 'Excavator ID',
            material_id INT,
            jam_berangkat TIME,
            jam_sampai TIME,
            jml_bucket INT DEFAULT 0,
            jml_tonase DECIMAL(10,2) DEFAULT 0,
            status TINYINT DEFAULT 0 COMMENT '0=Open, 1=Pergi, 2=Sampai, 3=Selesai',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (area_id) REFERENCES m_area(id) ON DELETE SET NULL,
            FOREIGN KEY (pit_id) REFERENCES m_pit(id) ON DELETE SET NULL,
            FOREIGN KEY (dt_id) REFERENCES m_heq(id) ON DELETE SET NULL,
            FOREIGN KEY (exca_id) REFERENCES m_heq(id) ON DELETE SET NULL,
            FOREIGN KEY (material_id) REFERENCES m_material(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "<p style='color:green;'>✓ Tabel m_pop berhasil dibuat.</p>";
} catch(PDOException $e) {
    echo "<p style='color:red;'>× Error membuat tabel m_pop: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Struktur Tabel m_pop:</h3>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr style='background:#333;color:#fff;'><th>Kolom</th><th>Tipe</th><th>Keterangan</th></tr>";
$columns = [
    ['id', 'INT AUTO_INCREMENT', 'Primary Key'],
    ['area_id', 'INT', 'FK ke m_area'],
    ['pit_id', 'INT', 'FK ke m_pit'],
    ['dt_id', 'INT', 'FK ke m_heq (Dump Truck)'],
    ['tanggal', 'DATE', 'Tanggal operasi'],
    ['jam_datang', 'TIME', 'Jam DT datang ke loading point'],
    ['exca_id', 'INT', 'FK ke m_heq (Excavator)'],
    ['material_id', 'INT', 'FK ke m_material'],
    ['jam_berangkat', 'TIME', 'Jam DT berangkat'],
    ['jam_sampai', 'TIME', 'Jam DT sampai tujuan'],
    ['jml_bucket', 'INT', 'Jumlah bucket yang dimuat'],
    ['jml_tonase', 'DECIMAL(10,2)', 'Jumlah tonase dalam ton'],
    ['status', 'TINYINT', '0=Open, 1=Pergi, 2=Sampai, 3=Selesai'],
    ['created_at', 'TIMESTAMP', 'Waktu dibuat'],
    ['updated_at', 'TIMESTAMP', 'Waktu diupdate']
];
foreach($columns as $col) {
    echo "<tr><td><b>{$col[0]}</b></td><td>{$col[1]}</td><td>{$col[2]}</td></tr>";
}
echo "</table>";

echo "<hr><p><b>Setup selesai!</b></p>";
echo "<p><a href='../view/m_pop/'>Buka Master POP</a></p>";
?>
