<?php
include '../config.php';

echo "<h2>Setup Master Kategori Material & Material</h2>";

try {
    $conn->exec("
        CREATE TABLE IF NOT EXISTS m_kategori_material (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nama VARCHAR(100) NOT NULL,
            des TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "<p style='color:green;'>✓ Tabel m_kategori_material berhasil dibuat.</p>";
} catch(PDOException $e) {
    echo "<p style='color:red;'>× Error membuat tabel m_kategori_material: " . $e->getMessage() . "</p>";
}

try {
    $conn->exec("
        CREATE TABLE IF NOT EXISTS m_material (
            id INT AUTO_INCREMENT PRIMARY KEY,
            kode VARCHAR(20) NOT NULL,
            nama VARCHAR(100) NOT NULL,
            des TEXT,
            kategori_id INT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (kategori_id) REFERENCES m_kategori_material(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "<p style='color:green;'>✓ Tabel m_material berhasil dibuat.</p>";
} catch(PDOException $e) {
    echo "<p style='color:red;'>× Error membuat tabel m_material: " . $e->getMessage() . "</p>";
}

$checkKat = $conn->query("SELECT COUNT(*) FROM m_kategori_material")->fetchColumn();
if($checkKat == 0) {
    try {
        $conn->exec("
            INSERT INTO m_kategori_material (nama, des) VALUES
            ('Produksi', 'Yang dijual'),
            ('Waste', 'Yang dibuang'),
            ('Reklamasi', 'Yang disimpan untuk nutup lubang tambang')
        ");
        echo "<p style='color:green;'>✓ Data awal kategori material berhasil ditambahkan.</p>";
    } catch(PDOException $e) {
        echo "<p style='color:red;'>× Error menambah data kategori: " . $e->getMessage() . "</p>";
    }
} else {
    echo "<p style='color:blue;'>ℹ Data kategori material sudah ada, skip insert.</p>";
}

$checkMat = $conn->query("SELECT COUNT(*) FROM m_material")->fetchColumn();
if($checkMat == 0) {
    try {
        $produksiId = $conn->query("SELECT id FROM m_kategori_material WHERE nama = 'Produksi'")->fetchColumn();
        $wasteId = $conn->query("SELECT id FROM m_kategori_material WHERE nama = 'Waste'")->fetchColumn();
        $reklamasiId = $conn->query("SELECT id FROM m_kategori_material WHERE nama = 'Reklamasi'")->fetchColumn();
        
        $stmt = $conn->prepare("
            INSERT INTO m_material (kode, nama, des, kategori_id) VALUES
            ('C', 'Batubara', 'Material batubara untuk produksi', :produksi),
            ('OB', 'Overburden', 'Material lapisan tanah penutup', :waste1),
            ('IB', 'Interburden', 'Material lapisan antara', :waste2),
            ('TS', 'Top Soil', 'Material tanah pucuk untuk reklamasi', :reklamasi)
        ");
        $stmt->execute([
            ':produksi' => $produksiId,
            ':waste1' => $wasteId,
            ':waste2' => $wasteId,
            ':reklamasi' => $reklamasiId
        ]);
        echo "<p style='color:green;'>✓ Data awal material berhasil ditambahkan.</p>";
    } catch(PDOException $e) {
        echo "<p style='color:red;'>× Error menambah data material: " . $e->getMessage() . "</p>";
    }
} else {
    echo "<p style='color:blue;'>ℹ Data material sudah ada, skip insert.</p>";
}

echo "<hr><p><b>Setup selesai!</b></p>";
echo "<p><a href='../view/m_kategori_material/'>Buka Master Kategori Material</a></p>";
echo "<p><a href='../view/m_material/'>Buka Master Material</a></p>";
?>
