<?php
// tools/setup_hauling.php

include '../config.php';

try {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1. Create m_type_unit
    $sql_type = "CREATE TABLE IF NOT EXISTS `m_type_unit` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `nama` varchar(100) NOT NULL,
      `des` text,
      `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
      `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    $conn->exec($sql_type);
    echo "Table m_type_unit created.\n";

    // Seed m_type_unit
    $units = [
        'Excavator', 'Dumptruck', 'Bulldozer', 'Motor Grader', 
        'Drilling', 'Compactor', 'Water Truck', 'Truck Coal', 'Pump'
    ];

    // Check if empty
    $stmt = $conn->query("SELECT COUNT(*) FROM m_type_unit");
    if ($stmt->fetchColumn() == 0) {
        $insert = "INSERT INTO m_type_unit (nama) VALUES (:nama)";
        $stmt_ins = $conn->prepare($insert);
        foreach ($units as $u) {
            $stmt_ins->execute([':nama' => $u]);
        }
        echo "Seeded m_type_unit.\n";
    }

    // 2. Create m_heq
    $sql_heq = "CREATE TABLE IF NOT EXISTS `m_heq` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `no_unit` varchar(50) NOT NULL,
      `type_id` int(11) NOT NULL,
      `brand_model` varchar(100),
      `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
      `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`),
      KEY `type_id` (`type_id`),
      CONSTRAINT `fk_heq_type` FOREIGN KEY (`type_id`) REFERENCES `m_type_unit` (`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    $conn->exec($sql_heq);
    echo "Table m_heq created.\n";

    // 3. Ensure users table exists (from sitem.sql structure, assuming it's already there but just in case)
    // We won't touch m_user since the user can log in with existing credentials.
    // Standard sitem m_user usually has level_id. 1=Admin.

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
