<?php
/**
 * Setup Fuel Management Tables
 * Run this file once to create required tables for Fuel Management module
 */
include '../config.php';

try {
    // Create m_fueling table
    $sql1 = "CREATE TABLE IF NOT EXISTS `m_fueling` (
        `id` int NOT NULL AUTO_INCREMENT,
        `tanggal` date NOT NULL,
        `heq_id` int NOT NULL COMMENT 'Heavy Equipment Unit ID',
        `operator_driver_id` int DEFAULT NULL COMMENT 'Driver or Operator User ID',
        `jumlah_liter` decimal(10,2) NOT NULL DEFAULT '0.00',
        `hm_awal` decimal(10,2) DEFAULT NULL COMMENT 'Hour Meter Awal',
        `hm_akhir` decimal(10,2) DEFAULT NULL COMMENT 'Hour Meter Akhir',
        `keterangan` text,
        `created_by` int DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `heq_id` (`heq_id`),
        KEY `operator_driver_id` (`operator_driver_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $conn->exec($sql1);
    echo "✅ Table m_fueling created successfully!<br>";

    // Create m_fuel_stock table
    $sql2 = "CREATE TABLE IF NOT EXISTS `m_fuel_stock` (
        `id` int NOT NULL AUTO_INCREMENT,
        `tanggal` date NOT NULL,
        `jenis` enum('Masuk','Keluar') NOT NULL DEFAULT 'Masuk',
        `jumlah_liter` decimal(10,2) NOT NULL DEFAULT '0.00',
        `keterangan` text,
        `created_by` int DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $conn->exec($sql2);
    echo "✅ Table m_fuel_stock created successfully!<br>";
    
    echo "<br><strong>All tables created successfully!</strong>";
    echo "<br><br><a href='../view/m_fueling/'>Go to Fueling Module</a>";

} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
