<?php
/**
 * Script untuk insert dummy data POP
 * Jalankan sekali saja untuk mengisi data sampel
 */

include '../config.php';

// Get existing data untuk foreign keys
$areas = $conn->query("SELECT id FROM m_area")->fetchAll(PDO::FETCH_COLUMN);
$pits = $conn->query("SELECT id, area_id FROM m_pit")->fetchAll(PDO::FETCH_ASSOC);
$dumptrucks = $conn->query("SELECT h.id FROM m_heq h LEFT JOIN m_type_unit t ON h.type_id = t.id WHERE t.nama = 'Dumptruck'")->fetchAll(PDO::FETCH_COLUMN);
$excavators = $conn->query("SELECT h.id FROM m_heq h LEFT JOIN m_type_unit t ON h.type_id = t.id WHERE t.nama = 'Excavator'")->fetchAll(PDO::FETCH_COLUMN);
$materials = $conn->query("SELECT id FROM m_material")->fetchAll(PDO::FETCH_COLUMN);

// Fallback jika tidak ada data equipment
if (empty($dumptrucks)) {
    // Insert sample dump trucks
    $conn->exec("INSERT INTO m_heq (no_unit, nama_unit, type_id, brand_model) VALUES 
        ('DT-001', 'Hino Ranger', 2, 'Hino Ranger 500'),
        ('DT-002', 'Mitsubishi Fuso', 2, 'Fuso Fighter'),
        ('DT-003', 'Volvo FMX', 2, 'Volvo FMX 440'),
        ('DT-004', 'Scania P410', 2, 'Scania P410 8x4'),
        ('DT-005', 'UD Quester', 2, 'UD Quester GWE 370')");
    $dumptrucks = $conn->query("SELECT h.id FROM m_heq h LEFT JOIN m_type_unit t ON h.type_id = t.id WHERE t.nama = 'Dumptruck'")->fetchAll(PDO::FETCH_COLUMN);
}

if (empty($excavators)) {
    // Insert sample excavators
    $conn->exec("INSERT INTO m_heq (no_unit, nama_unit, type_id, brand_model) VALUES 
        ('EX-001', 'Komatsu PC200', 1, 'Komatsu PC200-8'),
        ('EX-002', 'Caterpillar 320D', 1, 'CAT 320D2 GC'),
        ('EX-003', 'Hitachi ZX200', 1, 'Hitachi ZX200-5G'),
        ('EX-004', 'Kobelco SK200', 1, 'Kobelco SK200-10')");
    $excavators = $conn->query("SELECT h.id FROM m_heq h LEFT JOIN m_type_unit t ON h.type_id = t.id WHERE t.nama = 'Excavator'")->fetchAll(PDO::FETCH_COLUMN);
}

// Generate dummy POP data untuk 30 hari terakhir
$insertedCount = 0;
$startDate = date('Y-m-d', strtotime('-30 days'));
$endDate = date('Y-m-d');

$currentDate = $startDate;
while ($currentDate <= $endDate) {
    // Random 5-15 ritase per hari
    $ritasePerHari = rand(5, 15);
    
    for ($i = 0; $i < $ritasePerHari; $i++) {
        // Random pit and get matching area
        $randomPit = $pits[array_rand($pits)];
        $pit_id = $randomPit['id'];
        $area_id = $randomPit['area_id'];
        
        // Random equipment
        $dt_id = !empty($dumptrucks) ? $dumptrucks[array_rand($dumptrucks)] : null;
        $exca_id = !empty($excavators) ? $excavators[array_rand($excavators)] : null;
        $material_id = !empty($materials) ? $materials[array_rand($materials)] : null;
        
        // Random times (realistic hauling times)
        $baseHour = rand(6, 18);
        $jam_datang = sprintf("%02d:%02d:00", $baseHour, rand(0, 59));
        $jam_berangkat = sprintf("%02d:%02d:00", $baseHour, rand(10, 59));
        $jam_sampai = sprintf("%02d:%02d:00", min($baseHour + rand(1, 2), 23), rand(0, 59));
        
        // Random production values
        $jml_bucket = rand(3, 8);
        $jml_tonase = $jml_bucket * rand(8, 15); // 8-15 ton per bucket
        
        // Random status (most should be selesai for historical data)
        $status = 3; // Default selesai for historical
        if ($currentDate == $endDate) {
            // Today's data can have various statuses
            $status = rand(0, 3);
        }
        
        $sql = "INSERT INTO m_pop (area_id, pit_id, dt_id, exca_id, material_id, tanggal, jam_datang, jam_berangkat, jam_sampai, jml_bucket, jml_tonase, status) 
                VALUES (:area_id, :pit_id, :dt_id, :exca_id, :material_id, :tanggal, :jam_datang, :jam_berangkat, :jam_sampai, :jml_bucket, :jml_tonase, :status)";
        
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            ':area_id' => $area_id,
            ':pit_id' => $pit_id,
            ':dt_id' => $dt_id,
            ':exca_id' => $exca_id,
            ':material_id' => $material_id,
            ':tanggal' => $currentDate,
            ':jam_datang' => $jam_datang,
            ':jam_berangkat' => $jam_berangkat,
            ':jam_sampai' => $jam_sampai,
            ':jml_bucket' => $jml_bucket,
            ':jml_tonase' => $jml_tonase,
            ':status' => $status
        ]);
        
        $insertedCount++;
    }
    
    $currentDate = date('Y-m-d', strtotime($currentDate . ' +1 day'));
}

echo "<h2>✅ Dummy Data POP Berhasil Diinsert!</h2>";
echo "<p>Total: <strong>{$insertedCount}</strong> record POP telah ditambahkan untuk periode {$startDate} sampai {$endDate}</p>";
echo "<p><a href='../view/admin/'>Kembali ke Dashboard</a></p>";
?>
