<?php
/**
 * SimpleXLSX class
 * Library to parse XLSX files in PHP
 */

class SimpleXLSX {
    public $rows = [];
    public $sheets = [];
    public $sheetNames = [];
    public $package = [
        'filename' => '',
        'mtime'    => 0,
        'size'     => 0,
        'comment'  => '',
        'entries'  => []
    ];
    
    // Basic shared string cache
    private $sharedstrings = [];

    public static function parse($filename) {
        if(!class_exists('ZipArchive')) return false;
        
        $zip = new ZipArchive();
        if ($zip->open($filename) === true) {
            $obj = new self();
            
            // Read Shared Strings
            $sharedStrings = [];
            if ($content = $zip->getFromName('xl/sharedStrings.xml')) {
                $xml = simplexml_load_string($content);
                // Heavy loop for shared strings
                foreach ($xml->si as $si) {
                    $sharedStrings[] = (string)$si->t;
                }
            }

            // Read Sheet 1
             if ($content = $zip->getFromName('xl/worksheets/sheet1.xml')) {
                $xml = simplexml_load_string($content);
                $rows = [];
                foreach ($xml->sheetData->row as $row) {
                    $r = [];
                    $maxCol = 0;
                    
                    // First pass: determine max column and build associative array
                    $cellData = [];
                    foreach ($row->c as $c) {
                        $cellRef = (string)$c['r']; // e.g., "A1", "B1", "C1"
                        
                        // Extract column letter(s) from cell reference (e.g., "A" from "A1", "AB" from "AB1")
                        preg_match('/^([A-Z]+)/', $cellRef, $matches);
                        $colLetter = $matches[1];
                        
                        // Convert column letter to index (A=0, B=1, ... Z=25, AA=26, etc.)
                        $colIndex = 0;
                        $len = strlen($colLetter);
                        for ($i = 0; $i < $len; $i++) {
                            $colIndex = $colIndex * 26 + (ord($colLetter[$i]) - ord('A') + 1);
                        }
                        $colIndex--; // Make it 0-indexed
                        
                        if ($colIndex > $maxCol) $maxCol = $colIndex;
                        
                        // Get cell value
                        $val = (string)$c->v;
                        $t = (string)$c['t'];
                        
                        if ($t == 's') {
                            $val = isset($sharedStrings[$val]) ? $sharedStrings[$val] : $val;
                        }
                        
                        $cellData[$colIndex] = $val;
                    }
                    
                    // Second pass: build row array with empty strings for missing cells
                    for ($i = 0; $i <= $maxCol; $i++) {
                        $r[] = isset($cellData[$i]) ? $cellData[$i] : '';
                    }
                    
                    $rows[] = $r;
                }
                $obj->rows = $rows;
            }
            
            $zip->close();
            return $obj;
        }
        return false;
    }

    public function rows() {
        return $this->rows;
    }
}
?>
