<?php
include 'config.php';

if(!isset($_SESSION['email'] ) == 0) {
  header('Location: view/admin/');
}

if(isset($_POST['login'])) {
  $email    = $_POST['email'];
  $password = $_POST['password'];

  try {
    $sql = "SELECT * FROM m_user WHERE email = :email AND status_aktif = 1 AND level_id >= 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    $row = $stmt->fetch();
    
    if($row) {
        $hash_password = $row['password'];
        if (password_verify($password, $hash_password)){
            $_SESSION['email'] = $email;
            $_SESSION['nama'] = $row['nama'];
            $_SESSION['password'] = $row['password'];
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['level_id'] = $row['level_id'];
            
            if($row['level_id'] == 4) {
                 header("Location: view/peserta/");
            } else if($row['level_id'] == 3) {
                 header("Location: view/admin/");
            } else {
                 header("Location: view/admin/");
            }
            return;
        } else {
            $error = "Password Salah !";
        }
    } else {
        $error = "Email tidak ditemukan atau akun belum aktif !";
    }
  }
  catch(PDOException $e) {
    $error = $e->getMessage();
  }
}


$sqla = "SELECT * FROM setting ORDER BY id DESC";
$stmta = $conn->prepare($sqla);
$stmta->execute();
$rowa = $stmta->fetch();

?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo $rowa['nama']; ?> | Login</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="public/bower_components/bootstrap/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="public/bower_components/font-awesome/css/font-awesome.min.css">
  <link rel="icon" href="images/logo.png">
  <style>
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

/* ======================
   GLOBAL + BACKGROUND GRADIENT
====================== */
body {
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;

  /* GRADIENT CREAM */
  background: linear-gradient(
    135deg,
    #fffaf0 0%,
    #fdf6e3 40%,
    #f8f4e8 70%,
    #fdfcf8 100%
  );

  padding: 20px;
  position: relative;
  overflow-x: hidden;
  color: #0f172a;
}

body::before {
  content: '';
  position: absolute;
  inset: 0;
  background:
    radial-gradient(circle at top right, rgba(59,130,246,0.08), transparent 55%),
    radial-gradient(circle at bottom left, rgba(250,204,21,0.15), transparent 60%);
  pointer-events: none;
}

/* ======================
   CONTAINER
====================== */
.login-container {
  width: 100%;
  max-width: 400px;
  position: relative;
  z-index: 10;
  animation: fadeIn 0.8s ease-out;
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(20px); }
  to { opacity: 1; transform: translateY(0); }
}

/* ======================
   CARD
====================== */
.login-card {
  background: #fffdf7;
  border-radius: 14px;
  box-shadow: 0 20px 45px rgba(15, 23, 42, 0.18);
  overflow: hidden;
  border-top: 4px solid #facc15;
}

/* ======================
   HEADER
====================== */
.login-header {
  background: linear-gradient(
    180deg,
    #fffef9,
    #fffdf7
  );
  padding: 40px 30px 20px;
  text-align: center;
  border-bottom: 1px solid #e5e7eb;
}

.login-logo {
  margin-bottom: 20px;
  display: flex;
  justify-content: center;
}

.logo-img {
  max-width: 120px;
  filter: drop-shadow(0 4px 10px rgba(250, 204, 21, 0.35));
}

.login-header h1 {
  color: #0f172a;
  font-size: 24px;
  font-weight: 800;
  text-transform: uppercase;
}

/* ======================
   BODY
====================== */
.login-body {
  padding: 30px;
}

.login-subtitle {
  text-align: center;
  color: #475569;
  font-size: 14px;
  margin-bottom: 30px;
}

/* ======================
   FORM
====================== */
.form-group label {
  color: #0f172a;
  font-size: 12px;
  font-weight: 700;
  text-transform: uppercase;
}

.input-wrapper .form-control {
  background: #ffffff;
  border: 1px solid #dbeafe;
  color: #0f172a;
  border-radius: 8px;
  height: 45px;
}

.input-wrapper .form-control:focus {
  border-color: #2563eb;
  box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.15);
}

.input-wrapper .form-control::placeholder {
  color: #94a3b8;
}

.input-wrapper .input-icon {
  color: #94a3b8;
}

.input-wrapper .form-control:focus + .input-icon {
  color: #2563eb;
}

/* ======================
   OPTIONS
====================== */
.form-options {
  display: flex;
  justify-content: space-between;
  margin-bottom: 25px;
}

.remember-me {
  display: flex;
  align-items: center;
  gap: 10px;
}

.remember-me input {
  accent-color: #2563eb;
}

.remember-me span {
  color: #334155;
  font-size: 14px;
}

.forgot-link {
  color: #2563eb;
  font-size: 14px;
  font-weight: 700;
  text-decoration: none;
}

.forgot-link:hover {
  text-decoration: underline;
}

/* ======================
   BUTTONS
====================== */
.btn-login {
  width: 100%;
  height: 45px;
  background: linear-gradient(
    135deg,
    #2563eb,
    #3b82f6
  );
  color: #ffffff;
  font-weight: 800;
  text-transform: uppercase;
  border-radius: 8px;
  border: none;
  cursor: pointer;
  margin-bottom: 15px;
  box-shadow: 0 8px 25px rgba(37, 99, 235, 0.35);
}

.btn-login:hover {
  background: linear-gradient(
    135deg,
    #1d4ed8,
    #2563eb
  );
}

.btn-register {
  width: 100%;
  height: 45px;
  background: transparent;
  color: #0f172a;
  border: 2px solid #facc15;
  font-weight: 700;
  border-radius: 8px;
  cursor: pointer;
}

.btn-register:hover {
  background: #fef3c7;
}

/* ======================
   DIVIDER
====================== */
.divider span {
  background: #fffdf7;
  color: #64748b;
}

.divider::before,
.divider::after {
  background: #e5e7eb;
}

/* ======================
   RESPONSIVE
====================== */
@media (max-width: 480px) {
  .login-card {
    border-radius: 18px;
  }

  .btn-login,
  .btn-register {
    height: 50px;
  }
}
</style>


</head>
<body>
  <div class="login-container">
    <div class="login-card">
      <div class="login-header">
        <div class="login-logo">
          <img src="images/index.png" alt="Logo" class="logo-img">
        </div>
        <h1><?php echo $rowa['nama']; ?></h1>
      </div>
      
      <div class="login-body">
        <p class="login-subtitle">Silahkan masuk untuk memulai sesi</p>
        
        <?php if(isset($error)): ?>
          <div class="alert alert-danger">
            <button type="button" class="close" onclick="this.parentElement.style.display='none'">&times;</button>
            <?php echo $error; ?>
          </div>
        <?php endif; ?>
        
        <form action="" method="post">
          <div class="form-group">
            <label for="email">Email</label>
            <div class="input-wrapper">
              <input type="email" id="email" name="email" class="form-control" placeholder="Masukkan email anda" required>
              <i class="fa fa-envelope input-icon"></i>
            </div>
          </div>
          
          <div class="form-group">
            <label for="password">Password</label>
            <div class="input-wrapper">
              <input type="password" id="password" name="password" class="form-control" placeholder="Masukkan password anda" required>
              <i class="fa fa-eye input-icon" id="togglePassword" style="cursor: pointer; pointer-events: auto;"></i>
            </div>
          </div>
          
          <div class="form-options">
            <label class="remember-me">
              <input type="checkbox" name="remember">
              <span>Ingat Saya</span>
            </label>
            <a href="#" class="forgot-link">Lupa Password?</a>
          </div>
          
          <button type="submit" name="login" class="btn-login">
            <i class="fa fa-sign-in"></i> &nbsp; Masuk
          </button>
        </form>
        
        <div class="divider">
          <span>atau</span>
        </div>
        
        <button type="button" class="btn-register" data-toggle="modal" data-target="#exampleModal">
          <i class="fa fa-user-plus"></i> &nbsp; Daftar Akun Baru
        </button>
      </div>
    </div>
  </div>

  <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">
            <i class="fa fa-user-plus"></i> &nbsp; Registrasi Akun Baru
          </h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="daftarjo.php" method="post" enctype="multipart/form-data">
          <div class="modal-body">
            <input type="text" name="nik" class="form-control" placeholder="NIK" required autofocus>
            <input type="text" name="nama" class="form-control" placeholder="Nama Lengkap" required>
            <input type="text" name="hp" class="form-control" placeholder="Nomor HP / WhatsApp" required>
            <input type="email" name="email" class="form-control" placeholder="Email Address" required>
            <input type="password" name="password" class="form-control" placeholder="Password" required>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
            <button type="submit" class="btn btn-primary">Daftar Sekarang</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script src="public/bower_components/jquery/dist/jquery.min.js"></script>
  <script src="public/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
  <script>
    const togglePassword = document.querySelector('#togglePassword');
    const password = document.querySelector('#password');

    if (togglePassword) {
      togglePassword.addEventListener('click', function (e) {
        // toggle the type attribute
        const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
        password.setAttribute('type', type);
        // toggle the eye slash icon
        this.classList.toggle('fa-eye-slash');
        this.classList.toggle('fa-eye');
      });
    }
  </script>
</body>
</html>
