<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $area_id = $_POST['area_id'];
        $pit_id = $_POST['pit_id'];
        $rom_id = !empty($_POST['rom_id']) ? $_POST['rom_id'] : null;
        $dt_id = $_POST['dt_id'];
        $tanggal = $_POST['tanggal'];
        $jam_datang = $_POST['jam_datang'];
        $exca_id = $_POST['exca_id'];
        $driver_id = !empty($_POST['driver_id']) ? $_POST['driver_id'] : null;
        $operator_id = !empty($_POST['operator_id']) ? $_POST['operator_id'] : null;
        $material_id = $_POST['material_id'];
        $jam_berangkat = !empty($_POST['jam_berangkat']) ? $_POST['jam_berangkat'] : null;
        $jam_sampai = !empty($_POST['jam_sampai']) ? $_POST['jam_sampai'] : null;
        $jml_bucket = !empty($_POST['jml_bucket']) ? $_POST['jml_bucket'] : 0;
        $jml_tonase = !empty($_POST['jml_tonase']) ? $_POST['jml_tonase'] : 0;
        $status = isset($_POST['status']) ? $_POST['status'] : 0;

        try {
            $sql = "INSERT INTO m_pop (area_id, pit_id, rom_id, dt_id, tanggal, jam_datang, exca_id, driver_id, operator_id, material_id, jam_berangkat, jam_sampai, jml_bucket, jml_tonase, status) 
                    VALUES (:area_id, :pit_id, :rom_id, :dt_id, :tanggal, :jam_datang, :exca_id, :driver_id, :operator_id, :material_id, :jam_berangkat, :jam_sampai, :jml_bucket, :jml_tonase, :status)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':area_id' => $area_id,
                ':pit_id' => $pit_id,
                ':rom_id' => $rom_id,
                ':dt_id' => $dt_id,
                ':tanggal' => $tanggal,
                ':jam_datang' => $jam_datang,
                ':exca_id' => $exca_id,
                ':driver_id' => $driver_id,
                ':operator_id' => $operator_id,
                ':material_id' => $material_id,
                ':jam_berangkat' => $jam_berangkat,
                ':jam_sampai' => $jam_sampai,
                ':jml_bucket' => $jml_bucket,
                ':jml_tonase' => $jml_tonase,
                ':status' => $status
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data POP berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id = $_POST['id'];
        $area_id = $_POST['area_id'];
        $pit_id = $_POST['pit_id'];
        $rom_id = !empty($_POST['rom_id']) ? $_POST['rom_id'] : null;
        $dt_id = $_POST['dt_id'];
        $tanggal = $_POST['tanggal'];
        $jam_datang = $_POST['jam_datang'];
        $exca_id = $_POST['exca_id'];
        $driver_id = !empty($_POST['driver_id']) ? $_POST['driver_id'] : null;
        $operator_id = !empty($_POST['operator_id']) ? $_POST['operator_id'] : null;
        $material_id = $_POST['material_id'];
        $jam_berangkat = !empty($_POST['jam_berangkat']) ? $_POST['jam_berangkat'] : null;
        $jam_sampai = !empty($_POST['jam_sampai']) ? $_POST['jam_sampai'] : null;
        $jml_bucket = !empty($_POST['jml_bucket']) ? $_POST['jml_bucket'] : 0;
        $jml_tonase = !empty($_POST['jml_tonase']) ? $_POST['jml_tonase'] : 0;
        $status = isset($_POST['status']) ? $_POST['status'] : 0;

        try {
            $sql = "UPDATE m_pop SET area_id = :area_id, pit_id = :pit_id, rom_id = :rom_id, dt_id = :dt_id, tanggal = :tanggal, 
                    jam_datang = :jam_datang, exca_id = :exca_id, driver_id = :driver_id, operator_id = :operator_id, material_id = :material_id, jam_berangkat = :jam_berangkat, 
                    jam_sampai = :jam_sampai, jml_bucket = :jml_bucket, jml_tonase = :jml_tonase, status = :status WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':area_id' => $area_id,
                ':pit_id' => $pit_id,
                ':rom_id' => $rom_id,
                ':dt_id' => $dt_id,
                ':tanggal' => $tanggal,
                ':jam_datang' => $jam_datang,
                ':exca_id' => $exca_id,
                ':driver_id' => $driver_id,
                ':operator_id' => $operator_id,
                ':material_id' => $material_id,
                ':jam_berangkat' => $jam_berangkat,
                ':jam_sampai' => $jam_sampai,
                ':jml_bucket' => $jml_bucket,
                ':jml_tonase' => $jml_tonase,
                ':status' => $status,
                ':id' => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data POP berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update_status':
        $id = $_POST['id'];
        $status = $_POST['status'];
        $field_update = '';
        
        if($status == 1) {
            $field_update = ", jam_berangkat = :jam_now";
        } else if($status == 2) {
            $field_update = ", jam_sampai = :jam_now";
        }

        try {
            $sql = "UPDATE m_pop SET status = :status $field_update WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $params = [':status' => $status, ':id' => $id];
            if($status == 1 || $status == 2) {
                $params[':jam_now'] = date('H:i:s');
            }
            $stmt->execute($params);
            echo json_encode(['status' => 'success', 'message' => 'Status berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_pop WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data POP berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_pop WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_pit_by_area':
        $area_id = $_GET['area_id'];
        try {
            $sql = "SELECT * FROM m_pit WHERE area_id = :area_id ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':area_id' => $area_id]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_heq_by_type':
        $type = $_GET['type'];
        try {
            $sql = "SELECT h.*, t.nama as type_nama FROM m_heq h 
                    LEFT JOIN m_type_unit t ON h.type_id = t.id 
                    WHERE LOWER(t.nama) LIKE :type ORDER BY h.nama_unit ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':type' => '%' . strtolower($type) . '%']);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_rom_by_pit':
        $pit_id = $_GET['pit_id'];
        try {
            $sql = "SELECT * FROM m_rom WHERE pit_id = :pit_id AND status = 1 ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':pit_id' => $pit_id]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_drivers':
        try {
            $sql = "SELECT id, nama FROM m_user WHERE level_id = 3 AND status_aktif = 1 ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_operators':
        try {
            $sql = "SELECT id, nama FROM m_user WHERE level_id = 4 AND status_aktif = 1 ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
