<?php
// controller/PitController.php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $area_id = $_POST['area_id'];
        $nama    = $_POST['nama'];
        $des     = $_POST['des'];
        $status  = isset($_POST['status']) ? $_POST['status'] : 1;

        try {
            $sql = "INSERT INTO m_pit (area_id, nama, des, status) VALUES (:area_id, :nama, :des, :status)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':area_id' => $area_id,
                ':nama'    => $nama,
                ':des'     => $des,
                ':status'  => $status
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Pit berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id      = $_POST['id'];
        $area_id = $_POST['area_id'];
        $nama    = $_POST['nama'];
        $des     = $_POST['des'];
        $status  = isset($_POST['status']) ? $_POST['status'] : 1;

        try {
            $sql = "UPDATE m_pit SET area_id = :area_id, nama = :nama, des = :des, status = :status WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':area_id' => $area_id,
                ':nama'    => $nama,
                ':des'     => $des,
                ':status'  => $status,
                ':id'      => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Pit berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_pit WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Pit berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_pit WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
