<?php
// controller/MiningContController.php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $nama   = $_POST['nama'];
        $des    = isset($_POST['des']) ? $_POST['des'] : '';
        $hp     = isset($_POST['hp']) ? $_POST['hp'] : '';
        $pic    = isset($_POST['pic']) ? $_POST['pic'] : '';
        $alamat = isset($_POST['alamat']) ? $_POST['alamat'] : '';
        $codx   = isset($_POST['codx']) ? $_POST['codx'] : '';

        try {
            $sql = "INSERT INTO m_mining_cont (nama, des, hp, pic, alamat, codx) VALUES (:nama, :des, :hp, :pic, :alamat, :codx)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':nama' => $nama, 
                ':des' => $des, 
                ':hp' => $hp, 
                ':pic' => $pic, 
                ':alamat' => $alamat, 
                ':codx' => $codx
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Mining Contractor berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id     = $_POST['id'];
        $nama   = $_POST['nama'];
        $des    = isset($_POST['des']) ? $_POST['des'] : '';
        $hp     = isset($_POST['hp']) ? $_POST['hp'] : '';
        $pic    = isset($_POST['pic']) ? $_POST['pic'] : '';
        $alamat = isset($_POST['alamat']) ? $_POST['alamat'] : '';
        $codx   = isset($_POST['codx']) ? $_POST['codx'] : '';

        try {
            $sql = "UPDATE m_mining_cont SET nama = :nama, des = :des, hp = :hp, pic = :pic, alamat = :alamat, codx = :codx WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':nama' => $nama, 
                ':des' => $des, 
                ':hp' => $hp, 
                ':pic' => $pic, 
                ':alamat' => $alamat, 
                ':codx' => $codx,
                ':id' => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Mining Contractor berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_mining_cont WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Mining Contractor berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_mining_cont WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
