<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $kode = $_POST['kode'];
        $nama = $_POST['nama'];
        $des  = $_POST['des'];
        $kategori_id = $_POST['kategori_id'];
        try {
            $sql = "INSERT INTO m_material (kode, nama, des, kategori_id) VALUES (:kode, :nama, :des, :kategori_id)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':kode' => $kode, ':nama' => $nama, ':des' => $des, ':kategori_id' => $kategori_id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Material berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id   = $_POST['id'];
        $kode = $_POST['kode'];
        $nama = $_POST['nama'];
        $des  = $_POST['des'];
        $kategori_id = $_POST['kategori_id'];
        try {
            $sql = "UPDATE m_material SET kode = :kode, nama = :nama, des = :des, kategori_id = :kategori_id WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':kode' => $kode, ':nama' => $nama, ':des' => $des, ':kategori_id' => $kategori_id, ':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Material berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_material WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Material berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT m.*, k.nama as kategori_nama FROM m_material m LEFT JOIN m_kategori_material k ON m.kategori_id = k.id WHERE m.id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_all':
        try {
            $sql = "SELECT m.*, k.nama as kategori_nama FROM m_material m LEFT JOIN m_kategori_material k ON m.kategori_id = k.id ORDER BY m.id ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
