<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $nama = $_POST['nama'];
        $des  = $_POST['des'];
        try {
            $sql = "INSERT INTO m_kategori_material (nama, des) VALUES (:nama, :des)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':nama' => $nama, ':des' => $des]);
            echo json_encode(['status' => 'success', 'message' => 'Data Kategori Material berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id   = $_POST['id'];
        $nama = $_POST['nama'];
        $des  = $_POST['des'];
        try {
            $sql = "UPDATE m_kategori_material SET nama = :nama, des = :des WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':nama' => $nama, ':des' => $des, ':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Kategori Material berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_kategori_material WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Kategori Material berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_kategori_material WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_all':
        try {
            $sql = "SELECT * FROM m_kategori_material ORDER BY id ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
