<?php
// controller/HeavyEquipmentController.php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $no_unit        = $_POST['no_unit'];
        $nama_unit      = isset($_POST['nama_unit']) ? trim($_POST['nama_unit']) : '';
        $mining_cont_id = isset($_POST['mining_cont_id']) ? $_POST['mining_cont_id'] : null;
        $type_id        = $_POST['type_id'];
        $brand_model    = $_POST['brand_model'];

        // Validasi: nama_unit wajib diisi
        if (empty($nama_unit)) {
            echo json_encode(['status' => 'error', 'message' => 'Nama Unit wajib diisi']);
            exit;
        }

        try {
            $sql = "INSERT INTO m_heq (no_unit, nama_unit, mining_cont_id, type_id, brand_model) 
                    VALUES (:no_unit, :nama_unit, :mining_cont_id, :type_id, :brand_model)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':no_unit' => $no_unit, 
                ':nama_unit' => $nama_unit,
                ':mining_cont_id' => $mining_cont_id ? $mining_cont_id : null,
                ':type_id' => $type_id, 
                ':brand_model' => $brand_model
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Heavy Equipment berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id             = $_POST['id'];
        $no_unit        = $_POST['no_unit'];
        $nama_unit      = isset($_POST['nama_unit']) ? trim($_POST['nama_unit']) : '';
        $mining_cont_id = isset($_POST['mining_cont_id']) ? $_POST['mining_cont_id'] : null;
        $type_id        = $_POST['type_id'];
        $brand_model    = $_POST['brand_model'];

        // Validasi: nama_unit wajib diisi
        if (empty($nama_unit)) {
            echo json_encode(['status' => 'error', 'message' => 'Nama Unit wajib diisi']);
            exit;
        }

        try {
            $sql = "UPDATE m_heq SET 
                    no_unit = :no_unit, 
                    nama_unit = :nama_unit,
                    mining_cont_id = :mining_cont_id,
                    type_id = :type_id, 
                    brand_model = :brand_model 
                    WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':no_unit' => $no_unit, 
                ':nama_unit' => $nama_unit,
                ':mining_cont_id' => $mining_cont_id ? $mining_cont_id : null,
                ':type_id' => $type_id, 
                ':brand_model' => $brand_model, 
                ':id' => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Heavy Equipment berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_heq WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Heavy Equipment berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_heq WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
