<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $tanggal = $_POST['tanggal'];
        $heq_id = $_POST['heq_id'];
        $operator_driver_id = !empty($_POST['operator_driver_id']) ? $_POST['operator_driver_id'] : null;
        $jumlah_liter = !empty($_POST['jumlah_liter']) ? $_POST['jumlah_liter'] : 0;
        $hm_awal = !empty($_POST['hm_awal']) ? $_POST['hm_awal'] : null;
        $hm_akhir = !empty($_POST['hm_akhir']) ? $_POST['hm_akhir'] : null;
        $keterangan = !empty($_POST['keterangan']) ? $_POST['keterangan'] : null;
        $created_by = $_SESSION['id'] ?? null;

        try {
            $sql = "INSERT INTO m_fueling (tanggal, heq_id, operator_driver_id, jumlah_liter, hm_awal, hm_akhir, keterangan, created_by) 
                    VALUES (:tanggal, :heq_id, :operator_driver_id, :jumlah_liter, :hm_awal, :hm_akhir, :keterangan, :created_by)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':tanggal' => $tanggal,
                ':heq_id' => $heq_id,
                ':operator_driver_id' => $operator_driver_id,
                ':jumlah_liter' => $jumlah_liter,
                ':hm_awal' => $hm_awal,
                ':hm_akhir' => $hm_akhir,
                ':keterangan' => $keterangan,
                ':created_by' => $created_by
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Fueling berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id = $_POST['id'];
        $tanggal = $_POST['tanggal'];
        $heq_id = $_POST['heq_id'];
        $operator_driver_id = !empty($_POST['operator_driver_id']) ? $_POST['operator_driver_id'] : null;
        $jumlah_liter = !empty($_POST['jumlah_liter']) ? $_POST['jumlah_liter'] : 0;
        $hm_awal = !empty($_POST['hm_awal']) ? $_POST['hm_awal'] : null;
        $hm_akhir = !empty($_POST['hm_akhir']) ? $_POST['hm_akhir'] : null;
        $keterangan = !empty($_POST['keterangan']) ? $_POST['keterangan'] : null;

        try {
            $sql = "UPDATE m_fueling SET tanggal = :tanggal, heq_id = :heq_id, operator_driver_id = :operator_driver_id, 
                    jumlah_liter = :jumlah_liter, hm_awal = :hm_awal, hm_akhir = :hm_akhir, keterangan = :keterangan WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':tanggal' => $tanggal,
                ':heq_id' => $heq_id,
                ':operator_driver_id' => $operator_driver_id,
                ':jumlah_liter' => $jumlah_liter,
                ':hm_awal' => $hm_awal,
                ':hm_akhir' => $hm_akhir,
                ':keterangan' => $keterangan,
                ':id' => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Fueling berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_fueling WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Fueling berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_fueling WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_type_units':
        try {
            $sql = "SELECT * FROM m_type_unit ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_heq_by_type':
        $type_id = $_GET['type_id'];
        try {
            $sql = "SELECT h.*, t.nama as type_nama FROM m_heq h 
                    LEFT JOIN m_type_unit t ON h.type_id = t.id 
                    WHERE h.type_id = :type_id ORDER BY h.nama_unit ASC, h.no_unit ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':type_id' => $type_id]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_all_operators_drivers':
        try {
            // Get all drivers (level_id = 3) and operators (level_id = 4)
            $sql = "SELECT id, nama, level_id, 
                    CASE WHEN level_id = 3 THEN 'Driver' ELSE 'Operator' END as role 
                    FROM m_user 
                    WHERE level_id IN (3, 4) AND status_aktif = 1 
                    ORDER BY level_id ASC, nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
