<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'create':
        $tanggal = $_POST['tanggal'];
        $jenis = $_POST['jenis'];
        $jumlah_liter = !empty($_POST['jumlah_liter']) ? $_POST['jumlah_liter'] : 0;
        $keterangan = !empty($_POST['keterangan']) ? $_POST['keterangan'] : null;
        $created_by = $_SESSION['id'] ?? null;

        try {
            $sql = "INSERT INTO m_fuel_stock (tanggal, jenis, jumlah_liter, keterangan, created_by) 
                    VALUES (:tanggal, :jenis, :jumlah_liter, :keterangan, :created_by)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':tanggal' => $tanggal,
                ':jenis' => $jenis,
                ':jumlah_liter' => $jumlah_liter,
                ':keterangan' => $keterangan,
                ':created_by' => $created_by
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Stok BBM berhasil ditambahkan']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'update':
        $id = $_POST['id'];
        $tanggal = $_POST['tanggal'];
        $jenis = $_POST['jenis'];
        $jumlah_liter = !empty($_POST['jumlah_liter']) ? $_POST['jumlah_liter'] : 0;
        $keterangan = !empty($_POST['keterangan']) ? $_POST['keterangan'] : null;

        try {
            $sql = "UPDATE m_fuel_stock SET tanggal = :tanggal, jenis = :jenis, jumlah_liter = :jumlah_liter, keterangan = :keterangan WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                ':tanggal' => $tanggal,
                ':jenis' => $jenis,
                ':jumlah_liter' => $jumlah_liter,
                ':keterangan' => $keterangan,
                ':id' => $id
            ]);
            echo json_encode(['status' => 'success', 'message' => 'Data Stok BBM berhasil diupdate']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'delete':
        $id = $_POST['id'];
        try {
            $sql = "DELETE FROM m_fuel_stock WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            echo json_encode(['status' => 'success', 'message' => 'Data Stok BBM berhasil dihapus']);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get':
        $id = $_GET['id'];
        try {
            $sql = "SELECT * FROM m_fuel_stock WHERE id = :id";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($row);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_summary':
        try {
            // Get total masuk
            $sqlMasuk = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fuel_stock WHERE jenis = 'Masuk'";
            $stmtMasuk = $conn->prepare($sqlMasuk);
            $stmtMasuk->execute();
            $totalMasuk = $stmtMasuk->fetchColumn();

            // Get total keluar
            $sqlKeluar = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fuel_stock WHERE jenis = 'Keluar'";
            $stmtKeluar = $conn->prepare($sqlKeluar);
            $stmtKeluar->execute();
            $totalKeluar = $stmtKeluar->fetchColumn();

            // Get total used (from m_fueling)
            $sqlUsed = "SELECT COALESCE(SUM(jumlah_liter), 0) FROM m_fueling";
            $stmtUsed = $conn->prepare($sqlUsed);
            $stmtUsed->execute();
            $totalUsed = $stmtUsed->fetchColumn();

            // Calculate current stock
            $currentStock = $totalMasuk - $totalKeluar - $totalUsed;

            echo json_encode([
                'total_masuk' => $totalMasuk,
                'total_keluar' => $totalKeluar,
                'total_used' => $totalUsed,
                'current_stock' => $currentStock
            ]);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
