<?php
include '../config.php';

if(!isset($_SESSION['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch($action) {
    case 'get_report':
        $dari = isset($_GET['dari']) ? $_GET['dari'] : null;
        $sampai = isset($_GET['sampai']) ? $_GET['sampai'] : null;
        $type_id = isset($_GET['type_id']) ? $_GET['type_id'] : null;
        $heq_id = isset($_GET['heq_id']) ? $_GET['heq_id'] : null;

        try {
            $where = "1=1";
            $params = [];

            if($dari) {
                $where .= " AND f.tanggal >= :dari";
                $params[':dari'] = $dari;
            }
            if($sampai) {
                $where .= " AND f.tanggal <= :sampai";
                $params[':sampai'] = $sampai;
            }
            if($type_id) {
                $where .= " AND h.type_id = :type_id";
                $params[':type_id'] = $type_id;
            }
            if($heq_id) {
                $where .= " AND f.heq_id = :heq_id";
                $params[':heq_id'] = $heq_id;
            }

            $sql = "SELECT f.*, 
                    COALESCE(h.nama_unit, h.no_unit) as unit_nama,
                    h.no_unit,
                    t.nama as type_nama,
                    u.nama as user_nama,
                    CASE WHEN u.level_id = 3 THEN 'Driver' WHEN u.level_id = 4 THEN 'Operator' ELSE '-' END as user_role
                    FROM m_fueling f 
                    LEFT JOIN m_heq h ON f.heq_id = h.id 
                    LEFT JOIN m_type_unit t ON h.type_id = t.id
                    LEFT JOIN m_user u ON f.operator_driver_id = u.id 
                    WHERE $where
                    ORDER BY f.tanggal DESC, f.id DESC";
            
            $stmt = $conn->prepare($sql);
            $stmt->execute($params);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['status' => 'success', 'data' => $rows]);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_summary_by_unit':
        $dari = isset($_GET['dari']) ? $_GET['dari'] : null;
        $sampai = isset($_GET['sampai']) ? $_GET['sampai'] : null;

        try {
            $where = "1=1";
            $params = [];

            if($dari) {
                $where .= " AND f.tanggal >= :dari";
                $params[':dari'] = $dari;
            }
            if($sampai) {
                $where .= " AND f.tanggal <= :sampai";
                $params[':sampai'] = $sampai;
            }

            $sql = "SELECT 
                    h.id as heq_id,
                    COALESCE(h.nama_unit, h.no_unit) as unit_nama,
                    h.no_unit,
                    t.nama as type_nama,
                    COUNT(f.id) as total_pengisian,
                    COALESCE(SUM(f.jumlah_liter), 0) as total_liter,
                    COALESCE(AVG(f.jumlah_liter), 0) as avg_liter
                    FROM m_fueling f 
                    LEFT JOIN m_heq h ON f.heq_id = h.id 
                    LEFT JOIN m_type_unit t ON h.type_id = t.id
                    WHERE $where
                    GROUP BY h.id, h.nama_unit, h.no_unit, t.nama
                    ORDER BY total_liter DESC";
            
            $stmt = $conn->prepare($sql);
            $stmt->execute($params);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['status' => 'success', 'data' => $rows]);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_type_units':
        try {
            $sql = "SELECT * FROM m_type_unit ORDER BY nama ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    case 'get_heq_by_type':
        $type_id = $_GET['type_id'];
        try {
            $sql = "SELECT h.*, t.nama as type_nama FROM m_heq h 
                    LEFT JOIN m_type_unit t ON h.type_id = t.id 
                    WHERE h.type_id = :type_id ORDER BY h.nama_unit ASC, h.no_unit ASC";
            $stmt = $conn->prepare($sql);
            $stmt->execute([':type_id' => $type_id]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($rows);
        } catch(PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        break;
}
?>
