<?php
// Controller/AiController.php
include '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $userMessage = isset($input['message']) ? $input['message'] : '';

    if (empty($userMessage)) {
        echo json_encode(['status' => 'error', 'message' => 'Pesan tidak boleh kosong']);
        exit;
    }

    if (OPENAI_API_KEY === 'sk-proj-YOUR_API_KEY_HERE') {
         echo json_encode(['status' => 'error', 'message' => 'API Key belum dikonfigurasi. Hubungi Admin.']);
         exit;
    }

    // Call OpenAI API
    $api_url = 'https://api.openai.com/v1/chat/completions';
    $data = [
        'model' => 'gpt-3.5-turbo', // Or gpt-4
        'messages' => [
            ['role' => 'system', 'content' => 'Anda adalah mentor pendidikan yang bijaksana dan membantu. Anda membantu siswa belajar untuk ujian.'],
            ['role' => 'user', 'content' => $userMessage]
        ]
    ];

    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . OPENAI_API_KEY
    ]);

    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo json_encode(['status' => 'error', 'message' => 'Curl Error: ' . curl_error($ch)]);
    } else {
        $decoded = json_decode($response, true);
        if (isset($decoded['choices'][0]['message']['content'])) {
            echo json_encode([
                'status' => 'success', 
                'reply' => $decoded['choices'][0]['message']['content']
            ]);
        } else {
            // Log full response for debugging
            echo json_encode([
                'status' => 'error', 
                'message' => 'Gagal mendapatkan respon dari AI.',
                'debug' => $decoded
            ]);
        }
    }
    curl_close($ch);

} else {
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
}
?>
