<?php
// Controller/AdminController.php
include '../config.php';

$action = isset($_GET['action']) ? $_GET['action'] : '';

switch ($action) {
    case 'create':
        $nama = $_POST['nama'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
        $hp = isset($_POST['hp']) ? $_POST['hp'] : '';
        $level_id = 1; // Admin
        $status_aktif = 1;

        // Check Email
        $check = $conn->prepare("SELECT id FROM m_user WHERE email = :email");
        $check->execute(['email' => $email]);
        if($check->rowCount() > 0){
             echo json_encode(['status' => 'error', 'message' => 'Email sudah terdaftar']);
             exit;
        }

        $sql = "INSERT INTO m_user (nama, email, password, hp, level_id, status_aktif) 
                VALUES (:nama, :email, :password, :hp, :level_id, :status_aktif)";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            'nama' => $nama,
            'email' => $email,
            'password' => $password,
            'hp' => $hp,
            'level_id' => $level_id,
            'status_aktif' => $status_aktif
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Data admin berhasil disimpan']);
        break;

    case 'update':
        $id = $_POST['id'];
        $nama = $_POST['nama'];
        $email = $_POST['email'];
        $hp = isset($_POST['hp']) ? $_POST['hp'] : '';
        $status_aktif = isset($_POST['status_aktif']) ? $_POST['status_aktif'] : 1;
        
        $sql = "UPDATE m_user SET nama = :nama, email = :email, hp = :hp, status_aktif = :status_aktif WHERE id = :id";
        $params = [
            'nama' => $nama,
            'email' => $email,
            'hp' => $hp,
            'status_aktif' => $status_aktif,
            'id' => $id
        ];

        if(!empty($_POST['password'])){
            $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
            $sql = "UPDATE m_user SET nama = :nama, email = :email, hp = :hp, status_aktif = :status_aktif, password = :password WHERE id = :id";
            $params['password'] = $password;
        }

        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        echo json_encode(['status' => 'success', 'message' => 'Data admin berhasil diupdate']);
        break;

    case 'delete':
        $id = $_POST['id'];
        $stmt = $conn->prepare("DELETE FROM m_user WHERE id = :id");
        $stmt->execute(['id' => $id]);
        echo json_encode(['status' => 'success', 'message' => 'Data admin berhasil dihapus']);
        break;

    case 'get':
        $id = $_GET['id'];
        $stmt = $conn->prepare("SELECT * FROM m_user WHERE id = :id");
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($data['password']); // Don't send password
        echo json_encode($data);
        break;

    default:
        break;
}
?>
