<?php
session_start();

// ------------
// AUTO ROUTE
// ------------

// Full path ke file yang berjalan
$fullPath = realpath($_SERVER['SCRIPT_FILENAME']);

// Hilangkan bagian root project sebelum folder "view/"
$basePos = strpos($fullPath, 'view' . DIRECTORY_SEPARATOR);
$routePath = substr($fullPath, $basePos + strlen('view' . DIRECTORY_SEPARATOR));

// Ganti backslash → slash (supaya aman untuk Windows)
$routePath = str_replace('\\', '/', $routePath);

// Hapus ekstensi .php
$route = str_replace('.php', '', $routePath);

// ------------
// ACCESS RULES
// ------------
$access = [
    
    
/*
 |-------------------------------------------------------------|
 |  MENU PENGGUNA                                              |
 |  Akses untuk level:                                         |
 |   - 1 : Manager / Finance                                   |
 |   - 2 : Operator Umum                                       |
 |   - 5 : Supervisor                                          |
 |   - 6 : Staf                                                |
 |   - 7 : Operator Muatan                                     |
 |   - 8 : Operator Bongkaran                                  |
 |-------------------------------------------------------------|
 */

/*
 |-------------------------------------------------------------|
 |  DATA PENGGUNA - LEVEL 1 (Manager / Finance)                |
 |-------------------------------------------------------------|
 |  1. Hengky  - hengky@gmail.com    - qG3V5                    |
 |  2. Angel   - angelly@gmail.com   - f0Fhl                   |
 |  3. Meidy   - meidy@gmail.com     - 9cT4q                   |
 |  4. Chris   - chris@gmail.com     - w66rs                   |
 |  5. Lissa   - lissa@gmail.com     - Q58r3                   |
 |-------------------------------------------------------------|
 */
  // semua menu

/*
 |-------------------------------------------------------------|
 |  DATA PENGGUNA - LEVEL 5 (Supervisor)                       |
 |-------------------------------------------------------------|
 |  1. Ayrien  - ayrien@gmail.com    - 3jVx5                   |
 |-------------------------------------------------------------|
 */
 // semua menu kecuali menu pengguna


/*
 |-------------------------------------------------------------|
 |  DATA PENGGUNA - LEVEL 7 (Operator Muatan)                  |
 |-------------------------------------------------------------|
 |  1. Fandy   - fandy@gmail.com     - Ne1Y9                   |
 |-------------------------------------------------------------|
 */
 // semua order tapi hanya khusus order muatan, semua pengguna dan semua master data

/*
 |-------------------------------------------------------------|
 |  DATA PENGGUNA - LEVEL 8 (Operator Bongkaran)               |
 |-------------------------------------------------------------|
 |  1. Yeheskiel - kiel@gmail.com - JBG3k                      |
 |-------------------------------------------------------------|
 */
 // semua order tapi hanya khusus order bongkaran

    
    // MENU PENGGUNA
    'm_user/index'               => ['1','7'],
    'm_user/karyawan'            => ['1','7'],
    'm_user/shipper'             => ['1','7'],
    'm_user/consignee'           => ['1','7'],
    'm_user/ganti_password'      => ['1','5','7','8'],
    
    // MENU MASTER DATA
    'm_order_kat/index'         => ['1','7'],
    'm_order_katsub/index'      => ['1','7'],
    'm_condition/index'         => ['1','7'],
    'm_kategori_kas/index'      => ['1','7'],
    'm_rek/index'               => ['1','7'],
    'm_ttd/index'               => ['1','7'],
    'm_cap/index'               => ['1','7'],
    
    
    // MENU ORDER
    'm_order/tambah'         => ['1','2','7','8'],
    'm_order/index'          => ['1','2','5','7','8'],
        // AKSI
        'm_order/invoice'        => ['1','5'],
        'm_order/full'           => ['1','5'],
        'm_order/sum'            => ['1','5'],
        'm_order/harga'          => ['1','5'],
        'm_order/cetak'          => ['1','5'],
        'm_order/list'           => ['1','5'],
    'm_tempo/index'             => ['1','5'],    
    'm_order/periode'          => ['1','5'],
    'm_order/list_order'          => ['1','5'],
    
    // MENU KEUANGAN -------------------------------------
    
    // MENU ARUS KAS
    'm_kas/kasmasuk'         => ['1','5'],
    'm_kas/kaskeluar'         => ['1','5'],
    'm_kas/kasmutasi'         => ['1','5'],
    'm_kas/keluar'         => ['1','5'],
    'm_kas/index'         => ['1','5'],
    
    // MENU BEBAN USAHA
    'm_keuangan/index'         => ['1','5'],
    'm_keuangan/beban_umum_detail'         => ['1','5'],
    
    // MENU PIUTANG
    'm_kas/piutang'         => ['1','5'],
    'm_kas/piutangs'         => ['1','5'],
    'm_kas/piutangl'         => ['1','5'],
    
    // MENU LAPORAN
    'm_keuangan/laporder'         => ['1','5'],
        // AKSI
        'm_keuangan/edit_harga'         => ['1','5'],
    'l_masuk/index'         => ['1','5'],
    'l_piutang/index'         => ['1','5'],
        

    
];

// ------------
// CHECK ACCESS
// ------------
if (isset($access[$route])) {
    if (!in_array($_SESSION['level_id'], $access[$route])) {

        echo "<script>
        alert('Maaf! Anda tidak bisa mengakses halaman ini');
        document.location.href='../admin/';
        </script>";
        exit;
    }
}
?>
